/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.BiConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public interface WireParser<O>
extends BiConsumer<WireIn, O> {
    @NotNull
    public static <O> WireParser<O> wireParser(WireParselet<O> defaultConsumer) {
        return new VanillaWireParser<O>(defaultConsumer);
    }

    public WireParselet<O> getDefaultConsumer();

    default public void parseOne(@NotNull WireIn wireIn, O out) {
        StringBuilder sb = WireInternal.SBP.acquireStringBuilder();
        ValueIn valueIn = wireIn.readEventName(sb);
        WireParselet<O> consumer = this.lookup(sb);
        if (consumer == null) {
            consumer = this.getDefaultConsumer();
        }
        consumer.accept(sb, valueIn, out);
    }

    @Override
    default public void accept(WireIn wireIn, O marshallableOut) {
        while (wireIn.bytes().readRemaining() > 0L) {
            this.parseOne(wireIn, marshallableOut);
            this.consume(wireIn, ',');
            this.consume(wireIn, '}');
            wireIn.consumePadding();
        }
    }

    default public void consume(WireIn wireIn, char ch) {
        if (wireIn.bytes().peekUnsignedByte() == ch) {
            wireIn.bytes().readSkip(1L);
        }
    }

    public WireParselet<O> lookup(CharSequence var1);

    public VanillaWireParser<O> register(WireKey var1, WireParselet<O> var2);

    public WireParselet<O> lookup(int var1);
}

