/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.threads.BusyPauser;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.HeadNumberChecker;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireObjectInput;
import net.openhft.chronicle.wire.WireObjectOutput;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWire
implements Wire {
    protected static final boolean ASSERTIONS;
    protected final Bytes<?> bytes;
    protected final boolean use8bit;
    protected Pauser pauser = BusyPauser.INSTANCE;
    protected ClassLookup classLookup = ClassAliasPool.CLASS_ALIASES;
    protected Object parent;
    volatile Thread usedBy;
    volatile Throwable usedHere;
    volatile Throwable lastEnded;
    int usedCount = 0;
    private long headerNumber = Long.MIN_VALUE;
    private boolean notCompleteIsNotPresent;
    private ObjectOutput objectOutput;
    private ObjectInput objectInput;
    private static long ignoreHeaderCountIfNumberOfBytesBehindExceeds;
    private boolean insideHeader;
    private HeadNumberChecker headNumberChecker;

    public AbstractWire(@NotNull Bytes bytes, boolean use8bit) {
        this.bytes = bytes;
        this.use8bit = use8bit;
        this.notCompleteIsNotPresent = bytes.sharedMemory();
    }

    private static long throwNotEnoughSpace(int maxlen, Bytes<?> bytes) {
        throw new IllegalStateException("not enough space to write " + maxlen + " was " + bytes.writeRemaining());
    }

    private static void throwHeaderOverwritten(long position, int expectedHeader, Bytes<?> bytes) throws StreamCorruptedException {
        throw new StreamCorruptedException("Data at " + position + " overwritten? Expected: " + Integer.toHexString(expectedHeader) + " was " + Integer.toHexString(bytes.readVolatileInt(position)));
    }

    private static void throwLengthMismatch(int length, int actualLength) throws StreamCorruptedException {
        throw new StreamCorruptedException("Wrote " + actualLength + " when " + length + " was set initially.");
    }

    private static String exceptionStacktraceToString(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        ps.close();
        return baos.toString();
    }

    public boolean isInsideHeader() {
        return this.insideHeader;
    }

    @Override
    public Pauser pauser() {
        if (this.pauser == BusyPauser.INSTANCE) {
            this.pauser = new LongPauser(1000, 500, 1L, 10L, TimeUnit.MILLISECONDS);
        }
        return this.pauser;
    }

    @Override
    public void pauser(Pauser pauser) {
        this.pauser = pauser;
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.headerNumber(Long.MIN_VALUE);
    }

    private Wire headerNumber(long position, long headerNumber) {
        if (this.headNumberChecker != null) {
            this.headNumberChecker.checkHeaderNumber(headerNumber, position);
        }
        return this.headerNumber0(headerNumber);
    }

    @Override
    public Wire headerNumber(long headerNumber) {
        return this.headerNumber(this.bytes().writePosition(), headerNumber);
    }

    public Wire headerNumber0(long headerNumber) {
        this.headerNumber = headerNumber;
        return this;
    }

    public void headNumberCheck(HeadNumberChecker headNumberChecker) {
        this.headNumberChecker = headNumberChecker;
    }

    @Override
    public long headerNumber() {
        return this.headerNumber;
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        this.consumePadding();
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    public WireIn.HeaderType readDataHeader(boolean includeMetaData) throws EOFException {
        int header;
        while (Wires.isReady(header = this.bytes.peekVolatileInt())) {
            if (header == 0) {
                return WireIn.HeaderType.NONE;
            }
            if (Wires.isData(header)) {
                return WireIn.HeaderType.DATA;
            }
            if (includeMetaData && Wires.isReadyMetaData(header)) {
                return WireIn.HeaderType.META_DATA;
            }
            int bytesToSkip = Wires.lengthOf(header) + 4;
            this.bytes.readSkip((long)bytesToSkip);
        }
        if (header == -1073741824) {
            throw new EOFException();
        }
        return WireIn.HeaderType.NONE;
    }

    @Override
    public void readAndSetLength(long position) {
        int header = this.bytes.peekVolatileInt();
        if (Wires.isReady(header)) {
            if (header == 0) {
                throw new IllegalStateException();
            }
            long start = position + 4L;
            this.bytes.readPositionRemaining(start, (long)Wires.lengthOf(header));
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public void readMetaDataHeader() {
        int header = this.bytes.peekVolatileInt();
        if (Wires.isReady(header)) {
            if (header == 0) {
                throw new IllegalStateException("Meta data not initialised");
            }
            if (Wires.isReadyMetaData(header)) {
                this.setLimitPosition(header);
                return;
            }
        }
        throw new IllegalStateException("Meta data not ready " + Integer.toHexString(header));
    }

    private void setLimitPosition(int header) {
        ((Bytes)this.bytes.readLimit(this.bytes.readPosition() + (long)Wires.lengthOf(header) + 4L)).readSkip(4L);
    }

    @Override
    public void readFirstHeader(long timeout, TimeUnit timeUnit) throws TimeoutException, StreamCorruptedException {
        int header;
        while (!Wires.isReady(header = this.bytes.readVolatileInt(0L))) {
            this.pauser.pause(timeout, timeUnit);
        }
        this.pauser.reset();
        int len = Wires.lengthOf(header);
        if (!Wires.isReadyMetaData(header) || len > 65536) {
            throw new StreamCorruptedException("Unexpected magic number " + Integer.toHexString(header));
        }
        this.bytes.readPositionRemaining(4L, (long)len);
    }

    @Override
    public long writeHeader(int length, long timeout, TimeUnit timeUnit, @Nullable LongValue lastPosition) throws TimeoutException, EOFException {
        if (this.insideHeader) {
            throw new AssertionError((Object)"you cant put a header inside a header, check that you have not nested the documents.");
        }
        this.insideHeader = true;
        try {
            long lastPositionValue;
            if (length < 0 || length > 0x3FFFFFFF) {
                throw new IllegalArgumentException();
            }
            long pos = this.bytes.writePosition();
            if (this.bytes.compareAndSwapInt(pos, 0, Integer.MIN_VALUE | length)) {
                int maxlen;
                int n = maxlen = length == 0 ? 0x3FFFFFFF : length;
                if ((long)maxlen > this.bytes.writeRemaining()) {
                    return AbstractWire.throwNotEnoughSpace(maxlen, this.bytes);
                }
                this.bytes.writePositionRemaining(pos + 4L, (long)maxlen);
                return pos;
            }
            if (lastPosition != null && (lastPositionValue = lastPosition.getValue()) > this.bytes.writePosition() + ignoreHeaderCountIfNumberOfBytesBehindExceeds) {
                this.headerNumber(Long.MIN_VALUE);
                this.bytes.writePosition(lastPositionValue);
            }
            return this.writeHeader0(length, timeout, timeUnit);
        }
        catch (Throwable t) {
            this.insideHeader = false;
            throw t;
        }
    }

    private long writeHeader0(int length, long timeout, TimeUnit timeUnit) throws TimeoutException, EOFException {
        if (length < 0 || length > 0x3FFFFFFF) {
            throw new IllegalArgumentException();
        }
        long pos = this.bytes.writePosition();
        this.pauser();
        try {
            while (true) {
                int header2;
                if (this.bytes.compareAndSwapInt(pos, 0, Integer.MIN_VALUE | length)) {
                    int maxlen;
                    this.bytes.writePosition(pos + 4L);
                    int n = maxlen = length == 0 ? 0x3FFFFFFF : length;
                    if ((long)maxlen > this.bytes.writeRemaining()) {
                        AbstractWire.throwNotEnoughSpace(maxlen, this.bytes);
                    }
                    this.bytes.writeLimit(this.bytes.writePosition() + (long)maxlen);
                    long l = pos;
                    return l;
                }
                this.bytes.readPositionRemaining(pos, 0L);
                this.pauser.pause(timeout, timeUnit);
                int header = this.bytes.readVolatileInt(pos);
                if (header == -1073741824) {
                    throw new EOFException();
                }
                if (Wires.isNotComplete(header)) continue;
                int len = Wires.lengthOf(header);
                int nextHeader = Wires.lengthOf(this.bytes.readInt(pos + (long)len + 4L));
                if (nextHeader > 1024 && (header2 = this.bytes.readVolatileInt(pos)) != header) {
                    Jvm.warn().on(this.getClass(), "At pos: " + pos + " header: " + header + " header2: " + header2);
                    header = header2;
                }
                pos += (long)(len + 4);
                if (!Wires.isData(header)) continue;
                this.incrementHeaderNumber(pos);
            }
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void updateHeader(int length, long position, boolean metaData) throws StreamCorruptedException {
        if (this.bytes.writePosition() == position + 4L) {
            this.addPadding(1);
        }
        long pos = this.bytes.writePosition();
        int actualLength = Maths.toUInt31((long)(pos - position - 4L));
        int expectedHeader = Integer.MIN_VALUE | length;
        if (length == 0) {
            length = actualLength;
        } else if (length < actualLength) {
            AbstractWire.throwLengthMismatch(length, actualLength);
        }
        int header = length;
        if (metaData) {
            header |= 0x40000000;
        }
        if (header == 0) {
            throw new UnsupportedOperationException("Data messages of 0 length are not supported.");
        }
        assert (this.insideHeader);
        this.insideHeader = false;
        if (ASSERTIONS) {
            this.updateHeaderAssertions(position, pos, expectedHeader, header);
        } else {
            this.bytes.writeOrderedInt(position, header);
        }
        this.bytes.writeLimit(this.bytes.capacity());
        if (!metaData) {
            this.incrementHeaderNumber(position);
        }
    }

    void updateHeaderAssertions(long position, long pos, int expectedHeader, int header) throws StreamCorruptedException {
        this.checkNoDataAfterEnd(pos);
        if (!this.bytes.compareAndSwapInt(position, expectedHeader, header)) {
            throw new StreamCorruptedException("Data at " + position + " overwritten? Expected: " + Integer.toHexString(expectedHeader) + " was " + Integer.toHexString(this.bytes.readVolatileInt(position)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNoDataAfterEnd(long pos) {
        int value;
        if (pos <= this.bytes.realCapacity() - 4L && (value = this.bytes.bytesStore().readVolatileInt(pos)) != 0) {
            String text;
            long pos0 = this.bytes.readPosition();
            try {
                this.bytes.readPosition(pos);
                text = this.bytes.toDebugString();
            }
            finally {
                this.bytes.readPosition(pos0);
            }
            throw new IllegalStateException("Data was written after the end of the message, zero out data before rewinding " + text);
        }
    }

    private void incrementHeaderNumber(long pos) {
        if (this.headerNumber != Long.MIN_VALUE) {
            this.headerNumber(pos, this.headerNumber + 1L);
        }
    }

    @Override
    public boolean writeFirstHeader() {
        boolean cas = this.bytes.compareAndSwapInt(0L, 0, Integer.MIN_VALUE);
        if (cas) {
            this.bytes.writeSkip(4L);
        }
        return cas;
    }

    @Override
    public void updateFirstHeader() {
        long pos = this.bytes.writePosition();
        long actualLength = pos - 4L;
        if (actualLength >= 0x40000000L) {
            throw new IllegalStateException("Header too large was " + actualLength);
        }
        int header = (int)(0x40000000L | actualLength);
        if (!this.bytes.compareAndSwapInt(0L, Integer.MIN_VALUE, header)) {
            throw new IllegalStateException("Data at 0 overwritten? Expected: " + Integer.toHexString(Integer.MIN_VALUE) + " was " + Integer.toHexString(this.bytes.readVolatileInt(0L)));
        }
    }

    @Override
    public void writeEndOfWire(long timeout, TimeUnit timeUnit) throws TimeoutException {
        long pos = this.bytes.writePosition();
        try {
            while (true) {
                if (this.bytes.compareAndSwapInt(pos, 0, -1073741824)) {
                    this.bytes.writePosition(pos + 4L);
                    return;
                }
                this.pauser.pause(timeout, timeUnit);
                int header = this.bytes.readVolatileInt(pos);
                if (header == -1073741824) {
                    return;
                }
                if (header == Integer.MIN_VALUE) continue;
                int len = Wires.lengthOf(header);
                pos += (long)(len + 4);
            }
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public Object parent() {
        return this.parent;
    }

    @Override
    public void parent(Object parent) {
        this.parent = parent;
    }

    @Override
    public boolean startUse() {
        Throwable usedHere = this.usedHere;
        Thread usedBy = this.usedBy;
        if (usedBy != Thread.currentThread() && usedBy != null) {
            throw new IllegalStateException("Used by " + usedBy + " while trying to use it in " + Thread.currentThread(), usedHere);
        }
        this.usedBy = Thread.currentThread();
        this.usedHere = new Throwable();
        ++this.usedCount;
        return true;
    }

    @Override
    public boolean endUse() {
        if (this.usedBy != Thread.currentThread()) {
            throw new IllegalStateException("Used by " + this.usedHere, this.usedHere);
        }
        if (--this.usedCount <= 0) {
            this.usedBy = null;
            this.usedHere = null;
            this.usedCount = 0;
            this.lastEnded = new Throwable();
        }
        return true;
    }

    @Override
    public boolean notCompleteIsNotPresent() {
        return this.notCompleteIsNotPresent;
    }

    @Override
    public void notCompleteIsNotPresent(boolean notCompleteIsNotPresent) {
        this.notCompleteIsNotPresent = notCompleteIsNotPresent;
    }

    @Override
    public ObjectOutput objectOutput() {
        if (this.objectOutput == null) {
            this.objectOutput = new WireObjectOutput(this);
        }
        return this.objectOutput;
    }

    @Override
    public ObjectInput objectInput() {
        if (this.objectInput == null) {
            this.objectInput = new WireObjectInput(this);
        }
        return this.objectInput;
    }

    static {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERTIONS = assertions;
        ignoreHeaderCountIfNumberOfBytesBehindExceeds = Integer.getInteger("ignoreHeaderCountIfNumberOfBytesBehindExceeds", 0x100000).intValue();
    }
}

