/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSVWire
extends TextWire {
    static final ThreadLocal<StopCharTester> ESCAPED_END_OF_TEXT = ThreadLocal.withInitial(() -> StopCharTesters.COMMA_STOP.escaping());
    private final List<String> header = new ArrayList<String>();

    public CSVWire(Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
        while (this.lineStart == 0L) {
            this.header.add(this.valueIn.text());
        }
    }

    public CSVWire(Bytes bytes) {
        this(bytes, false);
    }

    public static CSVWire fromFile(String name) throws IOException {
        return new CSVWire(Bytes.wrapForRead((byte[])IOTools.readFile((String)name)), true);
    }

    @NotNull
    public static CSVWire from(@NotNull String text) {
        return new CSVWire(Bytes.from((CharSequence)text));
    }

    @Override
    @NotNull
    protected TextWire.TextValueOut createValueOut() {
        return new CSVValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new CSVValueIn();
    }

    @Override
    @NotNull
    public StringBuilder readField(@NotNull StringBuilder sb) {
        this.valueIn.text(sb);
        return sb;
    }

    @NotNull
    StopCharTester getEscapingCSVEndOfText() {
        StopCharTester escaping = ESCAPED_END_OF_TEXT.get();
        escaping.isStopChar(32);
        return escaping;
    }

    StopCharTester getEscapingSingleQuotes() {
        StopCharTester sct = (StopCharTester)ESCAPED_SINGLE_QUOTES.get();
        sct.isStopChar(32);
        return sct;
    }

    @Override
    public void consumePadding() {
        int codePoint;
        while (Character.isWhitespace(codePoint = this.peekCode()) || codePoint == 44) {
            if (codePoint == 10 || codePoint == 13) {
                this.lineStart = this.bytes.readPosition() + 1L;
            }
            this.bytes.readSkip(1L);
        }
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumePadding();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        s.setLength(0);
        return this;
    }

    @Override
    public boolean hasMore() {
        this.consumePadding();
        return this.bytes.readRemaining() > 0L;
    }

    class CSVValueIn
    extends TextWire.TextValueIn {
        CSVValueIn() {
            super(CSVWire.this);
        }

        @Nullable
        <ACS extends Appendable & CharSequence> ACS textTo0(@NotNull ACS a) {
            int prev;
            CSVWire.this.consumePadding();
            int ch = CSVWire.this.peekCode();
            switch (ch) {
                case 34: {
                    CSVWire.this.bytes.readSkip(1L);
                    if (CSVWire.this.use8bit) {
                        CSVWire.this.bytes.parse8bit(a, CSVWire.this.getEscapingQuotes());
                    } else {
                        CSVWire.this.bytes.parseUtf8(a, CSVWire.this.getEscapingQuotes());
                    }
                    TextWire.unescape(a);
                    int code = CSVWire.this.peekCode();
                    if (code != 34) break;
                    CSVWire.this.readCode();
                    break;
                }
                case 39: {
                    CSVWire.this.bytes.readSkip(1L);
                    if (CSVWire.this.use8bit) {
                        CSVWire.this.bytes.parse8bit(a, CSVWire.this.getEscapingSingleQuotes());
                    } else {
                        CSVWire.this.bytes.parseUtf8(a, CSVWire.this.getEscapingSingleQuotes());
                    }
                    TextWire.unescape(a);
                    int code = CSVWire.this.peekCode();
                    if (code != 39) break;
                    CSVWire.this.readCode();
                    break;
                }
                default: {
                    if (CSVWire.this.bytes.readRemaining() > 0L) {
                        if (a instanceof Bytes || CSVWire.this.use8bit) {
                            CSVWire.this.bytes.parse8bit(a, CSVWire.this.getEscapingCSVEndOfText());
                        } else {
                            CSVWire.this.bytes.parseUtf8(a, CSVWire.this.getEscapingCSVEndOfText());
                        }
                    } else {
                        AppendableUtil.setLength(a, (int)0);
                    }
                    while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                        AppendableUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                    }
                    break block0;
                }
            }
            if ((prev = this.peekBack()) == 58 || prev == 35 || prev == 125) {
                CSVWire.this.bytes.readSkip(-1L);
            }
            return a;
        }

        @Override
        protected long readLengthMarshallable() {
            long start = CSVWire.this.bytes.readPosition();
            try {
                CSVWire.this.consumePadding();
                while (true) {
                    int code = CSVWire.this.readCode();
                    switch (code) {
                        case -1: 
                        case 0: 
                        case 10: 
                        case 13: {
                            long l = CSVWire.this.bytes.readPosition() - start - 1L;
                            return l;
                        }
                    }
                }
            }
            finally {
                CSVWire.this.bytes.readPosition(start);
            }
        }

        @Override
        public boolean hasNextSequenceItem() {
            CSVWire.this.consumePadding();
            int ch = CSVWire.this.peekCode();
            if (ch == 44) {
                CSVWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public boolean marshallable(@NotNull ReadMarshallable object) {
            if (this.isNull()) {
                return false;
            }
            this.pushState();
            long len = this.readLengthMarshallable();
            long limit = CSVWire.this.bytes.readLimit();
            long position = CSVWire.this.bytes.readPosition();
            long newLimit = position + len;
            try {
                CSVWire.this.bytes.readLimit(newLimit);
                CSVWire.this.consumePadding();
                object.readMarshallable(CSVWire.this);
            }
            finally {
                CSVWire.this.bytes.readLimit(limit);
                CSVWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            CSVWire.this.consumePadding();
            return true;
        }
    }

    class CSVValueOut
    extends TextWire.TextValueOut {
        CSVValueOut() {
            super(CSVWire.this);
        }
    }
}

