/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public interface MarshallableIn
extends Closeable {
    public DocumentContext readingDocument();

    default public boolean readDocument(@NotNull ReadMarshallable reader) {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            reader.readMarshallable(dc.wire());
        }
        return true;
    }

    default public boolean readBytes(@NotNull ReadBytesMarshallable reader) {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            reader.readMarshallable(dc.wire().bytes());
        }
        return true;
    }

    default public boolean readBytes(@NotNull Bytes using) {
        using.clear();
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            using.write(dc.wire().bytes());
        }
        return true;
    }

    default public String readText() {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                String string = null;
                return string;
            }
            StringBuilder sb = Wires.acquireStringBuilder();
            dc.wire().bytes().parse8bit((Appendable)sb, (StopCharTester)StopCharTesters.ALL);
            String string = WireInternal.INTERNER.intern((CharSequence)sb);
            return string;
        }
    }

    default public boolean readText(StringBuilder sb) {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                sb.setLength(0);
                boolean bl = false;
                return bl;
            }
            dc.wire().getValueIn().text(sb);
        }
        return true;
    }

    default public Map<String, Object> readMap() {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                Map<String, Object> map = null;
                return map;
            }
            if (!dc.wire().hasMore()) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            StringBuilder sb = Wires.acquireStringBuilder();
            while (dc.wire().hasMore()) {
                Object o = dc.wire().readEventName(sb).object();
                ret.put(WireInternal.INTERNER.intern((CharSequence)sb), o);
            }
            LinkedHashMap<String, Object> linkedHashMap = ret;
            return linkedHashMap;
        }
    }

    default public MethodReader methodReader(Object ... objects) {
        return new MethodReader(this, objects);
    }
}

