/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;

public class ReadDocumentContext
implements DocumentContext {
    protected AbstractWire wire;
    protected boolean present;
    private boolean metaData;
    private long readPosition;
    private long readLimit;

    public ReadDocumentContext(Wire wire) {
        this.wire = (AbstractWire)wire;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void metaData(boolean metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    public Wire wire() {
        return this.wire;
    }

    public void close() {
        if (this.readLimit > 0L) {
            Bytes<?> bytes = this.wire.bytes();
            bytes.readLimit(this.readLimit);
            bytes.readPosition(this.readPosition);
        }
        this.wire.endUse();
    }

    public void start() {
        this.wire.startUse();
        this.readLimit = -1L;
        this.readPosition = -1L;
        Bytes<?> bytes = this.wire.bytes();
        if (bytes.readRemaining() < 4L) {
            this.present = false;
            return;
        }
        long position = bytes.readPosition();
        int header = bytes.readVolatileInt(position);
        if (header == 0 || Wires.isNotReady(header)) {
            this.present = false;
            return;
        }
        bytes.readSkip(4L);
        int len = Wires.lengthOf(header);
        if ((long)len > bytes.readRemaining()) {
            bytes.readSkip(-4L);
            this.present = false;
            return;
        }
        this.metaData = Wires.isReadyMetaData(header);
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition() + (long)len;
        bytes.readLimit(this.readPosition);
        this.present = true;
    }

    @Override
    public long index() {
        return 0L;
    }

    @Override
    public int sourceId() {
        return -1;
    }
}

