/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.wire.AbstractAnyWire;
import net.openhft.chronicle.wire.InternalWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class DeferredTypeWire
extends AbstractAnyWire
implements Wire,
InternalWire {
    private final Bytes bytes;

    public DeferredTypeWire(Bytes bytes, Supplier<WireType> wireTypeSupplier) {
        super(new DeferredTypeWireAcquisition(bytes, wireTypeSupplier));
        this.bytes = bytes;
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLookup classLookup() {
        return ClassAliasPool.CLASS_ALIASES;
    }

    @Override
    public void clear() {
        this.checkWire();
        this.bytes.clear();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        this.checkWire();
        return this.bytes;
    }

    static class DeferredTypeWireAcquisition
    implements AbstractAnyWire.WireAcquisition {
        private final Bytes bytes;
        private final Supplier<WireType> wireTypeSupplier;
        private InternalWire wire = null;
        private WireType wireType;

        public DeferredTypeWireAcquisition(Bytes bytes, Supplier<WireType> wireTypeSupplier) {
            this.bytes = bytes;
            this.wireTypeSupplier = wireTypeSupplier;
        }

        @Override
        public Supplier<WireType> underlyingType() {
            return () -> this.wireType;
        }

        @Override
        public InternalWire acquireWire() {
            if (this.wire != null) {
                return this.wire;
            }
            this.wireType = this.wireTypeSupplier.get();
            if (this.wireType == null) {
                throw new IllegalStateException("unknown type");
            }
            return (InternalWire)this.wireType.apply(this.bytes);
        }

        @Override
        public void classLookup(ClassLookup classLookup) {
        }

        @Override
        public ClassLookup classLookup() {
            return null;
        }

        public Bytes bytes() {
            return this.bytes;
        }
    }
}

