/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.CSVWire;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.ReadAnyWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public enum WireType implements Function<Bytes, Wire>
{
    TEXT{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new TextWire(bytes);
        }

        @Override
        public Supplier<LongValue> newLongReference() {
            return TextLongReference::new;
        }

        @Override
        public Supplier<LongArrayValues> newLongArrayReference() {
            return TextLongArrayReference::new;
        }
    }
    ,
    BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes);
        }

        @Override
        public String asString(WriteMarshallable marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    FIELDLESS_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, true, Integer.MAX_VALUE, "binary");
        }

        @Override
        public String asString(WriteMarshallable marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    COMPRESSED_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, false, COMPRESSED_SIZE, "lzw");
        }

        @Override
        public String asString(WriteMarshallable marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    JSON{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new JSONWire(bytes);
        }
    }
    ,
    RAW{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new RawWire(bytes);
        }

        @Override
        public String asString(WriteMarshallable marshallable) {
            return this.asHexString(marshallable);
        }

        @Override
        public <T> T fromString(CharSequence cs) {
            return this.fromHexString(cs);
        }
    }
    ,
    CSV{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new CSVWire(bytes);
        }
    }
    ,
    READ_ANY{

        @Override
        public Wire apply(@NotNull Bytes bytes) {
            return new ReadAnyWire(bytes);
        }
    };

    static final ThreadLocal<Bytes> bytesTL;
    private static final int COMPRESSED_SIZE;

    static Bytes getBytes() {
        Bytes bytes = bytesTL.get();
        bytes.clear();
        return bytes;
    }

    public Supplier<LongValue> newLongReference() {
        return BinaryLongReference::new;
    }

    public Supplier<LongArrayValues> newLongArrayReference() {
        return BinaryLongArrayReference::new;
    }

    public String asString(WriteMarshallable marshallable) {
        Bytes bytes = WireType.getBytes();
        Wire wire = (Wire)this.apply(bytes);
        wire.getValueOut().typedMarshallable(marshallable);
        return bytes.toString();
    }

    public <T> T fromString(CharSequence cs) {
        Bytes bytes = WireType.getBytes();
        bytes.appendUtf8(cs);
        Wire wire = (Wire)this.apply(bytes);
        return wire.getValueIn().typedMarshallable();
    }

    public <T> T fromFile(String filename) throws IOException {
        return ((Wire)this.apply(Bytes.wrapForRead((byte[])IOTools.readFile((String)filename)))).getValueIn().typedMarshallable();
    }

    public <T> Map<String, T> fromFileAsMap(String filename, Class<T> tClass) throws IOException {
        LinkedHashMap map = new LinkedHashMap();
        Wire wire = (Wire)this.apply(Bytes.wrapForRead((byte[])IOTools.readFile((String)filename)));
        StringBuilder sb = new StringBuilder();
        while (wire.hasMore()) {
            wire.readEventName(sb).object(tClass, map, (m, o) -> m.put(sb.toString(), o));
        }
        return map;
    }

    public <T extends Marshallable> void toFileAsMap(String filename, Map<String, T> map) throws IOException {
        this.toFileAsMap(filename, map, false);
    }

    public <T extends Marshallable> void toFileAsMap(String filename, Map<String, T> map, boolean compact) throws IOException {
        Bytes bytes = WireType.getBytes();
        Wire wire = (Wire)this.apply(bytes);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            ValueOut valueOut = wire.writeEventName(entry::getKey);
            if (compact) {
                valueOut.leaf();
            }
            valueOut.marshallable((WriteMarshallable)entry.getValue());
        }
        String tempFilename = IOTools.tempName((String)filename);
        IOTools.writeFile((String)tempFilename, (byte[])bytes.toByteArray());
        File file2 = new File(tempFilename);
        File dest = new File(filename);
        if (!file2.renameTo(dest)) {
            if (dest.delete() && file2.renameTo(dest)) {
                return;
            }
            file2.delete();
            throw new IOException("Failed to rename " + tempFilename + " to " + filename);
        }
    }

    public <T> void toFile(String filename, WriteMarshallable marshallable) throws IOException {
        Bytes bytes = WireType.getBytes();
        Wire wire = (Wire)this.apply(bytes);
        wire.getValueOut().typedMarshallable(marshallable);
        String tempFilename = IOTools.tempName((String)filename);
        IOTools.writeFile((String)tempFilename, (byte[])bytes.toByteArray());
        File file2 = new File(tempFilename);
        if (!file2.renameTo(new File(filename))) {
            file2.delete();
            throw new IOException("Failed to rename " + tempFilename + " to " + filename);
        }
    }

    String asHexString(WriteMarshallable marshallable) {
        Bytes bytes = WireType.getBytes();
        Wire wire = (Wire)this.apply(bytes);
        wire.getValueOut().typedMarshallable(marshallable);
        return bytes.toHexString();
    }

    <T> T fromHexString(CharSequence s) {
        Wire wire = (Wire)this.apply(Bytes.fromHexString((String)s.toString()));
        return wire.getValueIn().typedMarshallable();
    }

    static {
        bytesTL = ThreadLocal.withInitial(Bytes::allocateElasticDirect);
        COMPRESSED_SIZE = Integer.getInteger("WireType.compressedSize", 128);
    }
}

