/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.cfg.MapInstallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationCfg
implements MapInstallable {
    static final Logger LOGGER = LoggerFactory.getLogger(ApplicationCfg.class);
    final Map<String, MapInstallable> installableMap = new LinkedHashMap<String, MapInstallable>();
    final List<Consumer<Map<String, Object>>> toInstall = new ArrayList<Consumer<Map<String, Object>>>();

    @Override
    public Void install(String path, Map<String, Object> assetTree) throws Exception {
        LOGGER.info("Building Engine " + assetTree);
        for (Map.Entry<String, MapInstallable> entry : this.installableMap.entrySet()) {
            String path2 = entry.getKey();
            LOGGER.info("Installing " + path2 + ": " + entry.getValue());
            Object install = entry.getValue().install(path2, assetTree);
            if (install == null) continue;
            int pos = path2.lastIndexOf(47);
            String parent = path2.substring(0, pos);
            Map map = (Map)assetTree.computeIfAbsent(parent, s -> Collections.synchronizedMap(new LinkedHashMap()));
            String name = path2.substring(pos + 1);
            map.put(name, install);
        }
        for (Consumer consumer : this.toInstall) {
            consumer.accept(assetTree);
        }
        return null;
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.readMarshallable("", wire);
    }

    private void readMarshallable(String path, WireIn wire) {
        StringBuilder name = new StringBuilder();
        while (wire.hasMore()) {
            ValueIn in = wire.read(name);
            long pos = wire.bytes().readPosition();
            String path2 = path + "/" + name;
            if (in.isTyped()) {
                in.marshallable(w -> this.readMarshallable(path2, w));
                continue;
            }
            wire.bytes().readPosition(pos);
            Object o = in.typedMarshallable();
            this.installableMap.put(path2, (MapInstallable)o);
        }
    }
}

