/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.wire.AbstractAnyWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredTypeWire
extends AbstractAnyWire
implements Wire {
    public DeferredTypeWire(@NotNull Bytes bytes, Supplier<WireType> wireTypeSupplier) {
        super(bytes, new DeferredTypeWireAcquisition(bytes, wireTypeSupplier));
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLookup classLookup() {
        return ClassAliasPool.CLASS_ALIASES;
    }

    @Override
    public void clear() {
        this.checkWire();
        this.bytes.clear();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        this.checkWire();
        return this.bytes;
    }

    static class DeferredTypeWireAcquisition
    implements AbstractAnyWire.WireAcquisition {
        private final Bytes bytes;
        private final Supplier<WireType> wireTypeSupplier;
        @Nullable
        private Wire wire = null;
        private WireType wireType;

        public DeferredTypeWireAcquisition(Bytes bytes, Supplier<WireType> wireTypeSupplier) {
            this.bytes = bytes;
            this.wireTypeSupplier = wireTypeSupplier;
        }

        @Override
        @NotNull
        public Supplier<WireType> underlyingType() {
            return () -> this.wireType;
        }

        @Override
        @Nullable
        public Wire acquireWire() {
            if (this.wire != null) {
                return this.wire;
            }
            this.wireType = this.wireTypeSupplier.get();
            if (this.wireType == null) {
                throw new IllegalStateException("unknown type");
            }
            return (Wire)this.wireType.apply(this.bytes);
        }

        @Override
        public void classLookup(ClassLookup classLookup) {
        }

        @Override
        @Nullable
        public ClassLookup classLookup() {
            return null;
        }

        public Bytes bytes() {
            return this.bytes;
        }
    }
}

