/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public interface WireParser<O>
extends BiConsumer<WireIn, O> {
    @NotNull
    public static <O> WireParser<O> wireParser(WireParselet<O> defaultConsumer) {
        return new VanillaWireParser<O>(defaultConsumer);
    }

    public WireParselet<O> getDefaultConsumer();

    public void parseOne(@NotNull WireIn var1, O var2);

    @Override
    default public void accept(@NotNull WireIn wireIn, O marshallableOut) {
        Bytes<?> bytes = wireIn.bytes();
        while (bytes.readRemaining() > 0L) {
            long start = bytes.readPosition();
            this.parseOne(wireIn, marshallableOut);
            wireIn.consumePadding();
            if (bytes.readPosition() != start) continue;
            Jvm.warn().on(this.getClass(), "Failed to progress reading " + bytes.readRemaining() + " bytes left.");
            break;
        }
    }

    public WireParselet<O> lookup(CharSequence var1);

    @NotNull
    default public VanillaWireParser<O> registerOnce(WireKey key, WireParselet<O> valueInConsumer) {
        CharSequence name = key.name();
        if (this.lookup(name) != null) {
            Jvm.warn().on(this.getClass(), "Unable to register multiple methods for " + name + " ignoring one.");
        } else {
            this.register(key, valueInConsumer);
        }
        return (VanillaWireParser)this;
    }

    @NotNull
    public VanillaWireParser<O> register(WireKey var1, WireParselet<O> var2);

    public WireParselet<O> lookup(int var1);
}

