/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextIntReference;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.TextStopCharTesters;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xerial.snappy.Snappy;

public class CSVWire
extends TextWire {
    static final ThreadLocal<StopCharTester> ESCAPED_END_OF_TEXT = ThreadLocal.withInitial(() -> StopCharTesters.COMMA_STOP.escaping());
    private final List<String> header = new ArrayList<String>();

    public CSVWire(Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
        while (this.lineStart == 0L) {
            this.header.add(this.valueIn.text());
        }
    }

    public CSVWire(Bytes bytes) {
        this(bytes, false);
    }

    public static CSVWire fromFile(String name) throws IOException {
        return new CSVWire(Bytes.wrapForRead((byte[])IOTools.readFile((String)name)), true);
    }

    @NotNull
    public static CSVWire from(@NotNull String text) {
        return new CSVWire(Bytes.from((CharSequence)text));
    }

    @Override
    @NotNull
    protected TextWire.TextValueOut createValueOut() {
        return new CSVValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new CSVValueIn();
    }

    @Override
    @NotNull
    public StringBuilder readField(@NotNull StringBuilder sb) {
        this.valueIn.text(sb);
        return sb;
    }

    @NotNull
    private StopCharTester getEscapingEndOfText() {
        StopCharTester escaping = ESCAPED_END_OF_TEXT.get();
        escaping.isStopChar(32);
        return escaping;
    }

    private StopCharTester getEscapingQuotes() {
        StopCharTester sct = (StopCharTester)ESCAPED_QUOTES.get();
        sct.isStopChar(32);
        return sct;
    }

    private StopCharTester getEscapingSingleQuotes() {
        StopCharTester sct = (StopCharTester)ESCAPED_SINGLE_QUOTES.get();
        sct.isStopChar(32);
        return sct;
    }

    @Override
    void consumeWhiteSpace() {
        int codePoint;
        while (Character.isWhitespace(codePoint = this.peekCode()) || codePoint == 44) {
            if (codePoint == 10 || codePoint == 13) {
                this.lineStart = this.bytes.readPosition() + 1L;
            }
            this.bytes.readSkip(1L);
        }
    }

    @Override
    void consumeDocumentStart() {
        long pos;
        if (this.bytes.readRemaining() > 4L && this.bytes.readByte(pos = this.bytes.readPosition()) == 45 && this.bytes.readByte(pos + 1L) == 45 && this.bytes.readByte(pos + 2L) == 45) {
            this.bytes.readSkip(3L);
        }
    }

    @Override
    int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    private int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        s.setLength(0);
        return this;
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        this.consumeWhiteSpace();
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.appendUtf8((this.bytes.writePosition() & 0x3FL) == 0L ? 10 : 32);
        }
        return this;
    }

    @Override
    void escape(@NotNull CharSequence s) {
        Quotes quotes = this.needsQuotes(s);
        if (quotes == Quotes.NONE) {
            this.escape0(s, quotes);
            return;
        }
        this.bytes.appendUtf8((int)quotes.q);
        this.escape0(s, quotes);
        this.bytes.appendUtf8((int)quotes.q);
    }

    private void escape0(@NotNull CharSequence s, Quotes quotes) {
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.appendUtf8(92)).appendUtf8((int)ch);
                        continue block9;
                    }
                    this.bytes.appendUtf8((int)ch);
                    continue block9;
                }
                case '\'': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.appendUtf8(92)).appendUtf8((int)ch);
                        continue block9;
                    }
                    this.bytes.appendUtf8((int)ch);
                    continue block9;
                }
                case '\\': {
                    ((Bytes)this.bytes.appendUtf8(92)).appendUtf8((int)ch);
                    continue block9;
                }
                case '\b': {
                    this.bytes.appendUtf8((CharSequence)"\\b");
                    continue block9;
                }
                case '\t': {
                    this.bytes.appendUtf8((CharSequence)"\\t");
                    continue block9;
                }
                case '\r': {
                    this.bytes.appendUtf8((CharSequence)"\\r");
                    continue block9;
                }
                case '\n': {
                    this.bytes.appendUtf8((CharSequence)"\\n");
                    continue block9;
                }
                default: {
                    if (ch > '\u007f') {
                        this.bytes.appendUtf8((CharSequence)"\\u");
                        this.bytes.appendUtf8((int)HEX[ch >> 12 & 0xF]);
                        this.bytes.appendUtf8((int)HEX[ch >> 8 & 0xF]);
                        this.bytes.appendUtf8((int)HEX[ch >> 4 & 0xF]);
                        this.bytes.appendUtf8((int)HEX[ch & 0xF]);
                        continue block9;
                    }
                    this.bytes.appendUtf8((int)ch);
                }
            }
        }
    }

    @Override
    protected Quotes needsQuotes(@NotNull CharSequence s) {
        Quotes quotes = Quotes.NONE;
        if (s.length() == 0) {
            return Quotes.DOUBLE;
        }
        if (STARTS_QUOTE_CHARS.get(s.charAt(0))) {
            return Quotes.DOUBLE;
        }
        for (int i = 1; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (QUOTE_CHARS.get(ch)) {
                return Quotes.DOUBLE;
            }
            if (ch != '\"') continue;
            quotes = Quotes.SINGLE;
        }
        return quotes;
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    @Override
    public void parseWord(StringBuilder sb) {
        this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
    }

    @Override
    public void parseUntil(StringBuilder sb, StopCharTester testers) {
        if (this.use8bit) {
            this.bytes.parse8bit((Appendable)sb, testers);
        } else {
            this.bytes.parseUTF((Appendable)sb, testers);
        }
    }

    @Override
    public void parseUntil(StringBuilder sb, StopCharsTester testers) {
        sb.setLength(0);
        if (this.use8bit) {
            AppendableUtil.read8bitAndAppend((StreamingDataInput)this.bytes, (StringBuilder)sb, (StopCharsTester)testers);
        } else {
            try {
                AppendableUtil.readUTFAndAppend((StreamingDataInput)this.bytes, (Appendable)sb, (StopCharsTester)testers);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void append(CharSequence cs) {
        if (this.use8bit) {
            this.bytes.append8bit(cs);
        } else {
            this.bytes.appendUtf8(cs);
        }
    }

    public void append(CharSequence cs, int offset) {
        if (this.use8bit) {
            this.bytes.append8bit(cs, offset, cs.length());
        } else {
            this.bytes.appendUtf8(cs, offset, cs.length() - offset);
        }
    }

    @Override
    public Object readObject() {
        this.consumeWhiteSpace();
        this.consumeDocumentStart();
        return this.readObject(0);
    }

    @Override
    Object readObject(int indentation) {
        this.consumeWhiteSpace();
        int code = this.peekCode();
        int indentation2 = this.indentation();
        if (indentation2 < indentation) {
            return NoObject.NO_OBJECT;
        }
        switch (code) {
            case 45: {
                if (this.bytes.readByte(this.bytes.readPosition() + 1L) == 45) {
                    return NoObject.NO_OBJECT;
                }
                return this.readList(indentation2);
            }
            case 91: {
                return this.readList();
            }
            case 123: {
                return this.readMap();
            }
            case 33: {
                return this.readTypedObject();
            }
        }
        return this.readMap(indentation2);
    }

    private int indentation() {
        return Maths.toInt32((long)(this.bytes.readPosition() - this.lineStart));
    }

    private Object readTypedObject() {
        return this.valueIn.object(Object.class);
    }

    private List readList() {
        throw new UnsupportedOperationException();
    }

    @Override
    List readList(int indentation) {
        ArrayList<Object> objects = new ArrayList<Object>();
        while (this.peekCode() == 45 && this.indentation() >= indentation && this.bytes.readByte(this.bytes.readPosition() + 1L) != 45) {
            long ls = this.lineStart;
            this.bytes.readSkip(1L);
            this.consumeWhiteSpace();
            if (this.lineStart == ls) {
                objects.add(this.valueIn.objectWithInferredType(Object.class));
            } else {
                Object e = this.readObject(indentation);
                if (e != NoObject.NO_OBJECT) {
                    objects.add(e);
                }
            }
            this.consumeWhiteSpace();
        }
        return objects;
    }

    @Override
    Map readMap() {
        this.bytes.readSkip(1L);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        StringBuilder sb = WireInternal.acquireAnotherStringBuilder(WireInternal.acquireStringBuilder());
        while (this.bytes.readRemaining() > 0L) {
            this.consumeWhiteSpace();
            if (this.peekCode() == 125) {
                this.bytes.readSkip(1L);
                break;
            }
            this.read(sb);
            String key = WireInternal.INTERNER.intern((CharSequence)sb);
            Object value = this.valueIn.objectWithInferredType(Object.class);
            map.put(key, value);
        }
        return map;
    }

    private Map readMap(int indentation) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        StringBuilder sb = WireInternal.acquireAnotherStringBuilder(WireInternal.acquireStringBuilder());
        while (this.bytes.readRemaining() > 0L) {
            this.consumeWhiteSpace();
            if (this.indentation() < indentation || this.bytes.readRemaining() == 0L) break;
            this.read(sb);
            String key = WireInternal.INTERNER.intern((CharSequence)sb);
            if (key.equals("...")) break;
            Object value = this.valueIn.objectWithInferredType(Object.class);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void writeObject(Object o) {
        if (o instanceof Iterable) {
            for (Object o2 : (Iterable)o) {
                this.writeObject(o2, 2);
            }
        } else if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                this.write(() -> entry.getKey().toString()).object(entry.getValue());
            }
        } else if (o instanceof WriteMarshallable) {
            this.valueOut.typedMarshallable((WriteMarshallable)o);
        } else {
            this.valueOut.object(o);
        }
    }

    private void writeObject(Object o, int indentation) {
        this.bytes.appendUtf8(45);
        this.bytes.appendUtf8(32);
        this.indentation(indentation - 2);
        this.valueOut.object(o);
    }

    private void indentation(int indentation) {
        while (indentation-- > 0) {
            this.bytes.appendUtf8(32);
        }
    }

    class CSVValueIn
    extends TextWire.TextValueIn {
        CSVValueIn() {
            super(CSVWire.this);
        }

        @Override
        public String text() {
            return StringUtils.toString((Object)this.textTo(WireInternal.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            return this.textTo0((Appendable & CharSequence)sb);
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            return this.textTo0(bytes);
        }

        @Nullable
        <ACS extends Appendable & CharSequence> ACS textTo0(@NotNull ACS a) {
            int prev;
            CSVWire.this.consumeWhiteSpace();
            int ch = CSVWire.this.peekCode();
            switch (ch) {
                case 123: {
                    long len = this.readLength();
                    AppendableUtil.append(a, (CharSequence)CSVWire.this.bytes, (long)CSVWire.this.bytes.readPosition(), (long)len);
                    CSVWire.this.bytes.readSkip(len);
                    CSVWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                    return a;
                }
                case 34: {
                    CSVWire.this.bytes.readSkip(1L);
                    if (CSVWire.this.use8bit) {
                        CSVWire.this.bytes.parse8bit(a, CSVWire.this.getEscapingQuotes());
                    } else {
                        CSVWire.this.bytes.parseUTF(a, CSVWire.this.getEscapingQuotes());
                    }
                    TextWire.unescape(a);
                    int code = CSVWire.this.peekCode();
                    if (code != 34) break;
                    CSVWire.this.readCode();
                    break;
                }
                case 39: {
                    CSVWire.this.bytes.readSkip(1L);
                    if (CSVWire.this.use8bit) {
                        CSVWire.this.bytes.parse8bit(a, CSVWire.this.getEscapingSingleQuotes());
                    } else {
                        CSVWire.this.bytes.parseUTF(a, CSVWire.this.getEscapingSingleQuotes());
                    }
                    TextWire.unescape(a);
                    int code = CSVWire.this.peekCode();
                    if (code != 39) break;
                    CSVWire.this.readCode();
                    break;
                }
                case 33: {
                    CSVWire.this.bytes.readSkip(1L);
                    ch = CSVWire.this.peekCode();
                    if (ch == 33) {
                        CSVWire.this.bytes.readSkip(1L);
                        StringBuilder sb = WireInternal.acquireStringBuilder();
                        CSVWire.this.parseWord(sb);
                        if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"null")) {
                            this.textTo(sb);
                            return null;
                        }
                        if (!StringUtils.isEqual((CharSequence)sb, (CharSequence)"snappy")) break;
                        this.textTo(sb);
                        try {
                            byte[] decodedBytes = Base64.getDecoder().decode(sb.toString().getBytes());
                            String csq = Snappy.uncompressString((byte[])decodedBytes);
                            return (ACS)WireInternal.acquireStringBuilder().append(csq);
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    StringBuilder sb = WireInternal.acquireStringBuilder();
                    this.textTo(sb);
                    break;
                }
                default: {
                    if (CSVWire.this.bytes.readRemaining() > 0L) {
                        if (a instanceof Bytes || CSVWire.this.use8bit) {
                            CSVWire.this.bytes.parse8bit(a, CSVWire.this.getEscapingEndOfText());
                        } else {
                            CSVWire.this.bytes.parseUTF(a, CSVWire.this.getEscapingEndOfText());
                        }
                    } else {
                        AppendableUtil.setLength(a, (int)0);
                    }
                    while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                        AppendableUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                    }
                    break block1;
                }
            }
            if ((prev = this.peekBack()) == 58 || prev == 35 || prev == 125) {
                CSVWire.this.bytes.readSkip(-1L);
            }
            return a;
        }

        private int peekBack() {
            while (CSVWire.this.bytes.readPosition() >= CSVWire.this.bytes.start()) {
                int prev = CSVWire.this.bytes.readUnsignedByte(CSVWire.this.bytes.readPosition() - 1L);
                if (prev != 32) {
                    if (prev == 10 || prev == 13) {
                        CSVWire.this.lineStart = CSVWire.this.bytes.readPosition();
                    }
                    return prev;
                }
                CSVWire.this.bytes.readSkip(-1L);
            }
            return -1;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            return this.bytes((WireIn wi) -> toBytes.write(wi.bytes()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadMarshallable bytesConsumer) {
            CSVWire.this.consumeWhiteSpace();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (CSVWire.this.peekCode() == 33) {
                CSVWire.this.parseWord(sb);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if (str.equals("!!binary")) {
                    AppendableUtil.setLength((Appendable)sb, (int)0);
                    CSVWire.this.parseWord(sb);
                    byte[] decode = Base64.getDecoder().decode(sb.toString());
                    bytesConsumer.readMarshallable(new CSVWire(Bytes.wrapForRead((byte[])decode)));
                    return CSVWire.this;
                } else {
                    if (!str.equals("!!null")) throw new IORuntimeException("Unsupported type=" + str);
                    bytesConsumer.readMarshallable(null);
                    CSVWire.this.parseWord(sb);
                }
                return CSVWire.this;
            } else {
                this.textTo(sb);
                bytesConsumer.readMarshallable(new CSVWire(Bytes.wrapForRead((byte[])sb.toString().getBytes())));
            }
            return CSVWire.this;
        }

        @Override
        @Nullable
        public byte[] bytes() {
            CSVWire.this.consumeWhiteSpace();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (CSVWire.this.peekCode() == 33) {
                CSVWire.this.parseWord(sb);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if (str.equals("!!binary")) {
                    AppendableUtil.setLength((Appendable)sb, (int)0);
                    CSVWire.this.parseWord(sb);
                    byte[] decode = Base64.getDecoder().decode(WireInternal.INTERNER.intern((CharSequence)sb));
                    return decode;
                }
                if (str.equals("!!null")) {
                    CSVWire.this.parseWord(sb);
                    return null;
                }
                if (str.equals("!!seqmap")) {
                    sb.append((CharSequence)CSVWire.this.bytes);
                    return WireInternal.INTERNER.intern((CharSequence)sb).getBytes();
                }
                throw new IllegalStateException("unsupported type=" + str);
            }
            this.textTo(sb);
            return sb.toString().getBytes();
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return CSVWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            CSVWire.this.consumeWhiteSpace();
            long start = CSVWire.this.bytes.readPosition();
            try {
                CSVWire.this.consumeWhiteSpace();
                int code = CSVWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = CSVWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b == 125) {
                                if (--count != 0) continue;
                                long l = CSVWire.this.bytes.readPosition() - start;
                                return l;
                            }
                            if (b != 0) continue;
                            long l = CSVWire.this.bytes.readPosition() - start - 1L;
                            return l;
                        }
                    }
                    case 45: {
                        while (true) {
                            byte b;
                            if ((b = CSVWire.this.bytes.readByte()) >= 32) continue;
                            long l = CSVWire.this.bytes.readLimit() - start - 1L;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = CSVWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                CSVWire.this.bytes.readPosition(start);
            }
        }

        private long readLengthMarshallable() {
            long start = CSVWire.this.bytes.readPosition();
            try {
                CSVWire.this.consumeWhiteSpace();
                while (true) {
                    int code = CSVWire.this.readCode();
                    switch (code) {
                        case -1: 
                        case 0: 
                        case 10: 
                        case 13: {
                            long l = CSVWire.this.bytes.readPosition() - start - 1L;
                            return l;
                        }
                    }
                }
            }
            finally {
                CSVWire.this.bytes.readPosition(start);
            }
        }

        @Override
        public boolean hasNext() {
            return CSVWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            CSVWire.this.consumeWhiteSpace();
            int ch = CSVWire.this.peekCode();
            if (ch == 44) {
                CSVWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        @Override
        @NotNull
        public WireIn int64(@Nullable LongValue value) {
            CSVWire.this.consumeWhiteSpace();
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)CSVWire.this.bytes, CSVWire.this.bytes.readPosition(), length);
            CSVWire.this.bytes.readSkip(length);
            CSVWire.this.consumeWhiteSpace();
            if (CSVWire.this.peekCode() == 44) {
                CSVWire.this.bytes.readSkip(1L);
            }
            return CSVWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            CSVWire.this.consumeWhiteSpace();
            long len = this.readLengthMarshallable();
            long limit = CSVWire.this.bytes.readLimit();
            long position = CSVWire.this.bytes.readPosition();
            try {
                long newLimit = position - 1L + len;
                CSVWire.this.bytes.readLimit(newLimit);
                CSVWire.this.bytes.readSkip(1L);
                CSVWire.this.consumeWhiteSpace();
                T t = marshallableReader.apply(CSVWire.this);
                return t;
            }
            finally {
                CSVWire.this.bytes.readLimit(limit);
                CSVWire.this.consumeWhiteSpace();
            }
        }

        @Override
        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            CSVWire.this.consumeWhiteSpace();
            long len = this.readLengthMarshallable();
            long limit = CSVWire.this.bytes.readLimit();
            long position = CSVWire.this.bytes.readPosition();
            long newLimit = position + len;
            try {
                CSVWire.this.bytes.readLimit(newLimit);
                CSVWire.this.consumeWhiteSpace();
                object.readMarshallable(CSVWire.this);
            }
            finally {
                CSVWire.this.bytes.readLimit(limit);
                CSVWire.this.bytes.readPosition(newLimit);
            }
            CSVWire.this.consumeWhiteSpace();
            return CSVWire.this;
        }

        @Override
        @Nullable
        public <T extends ReadMarshallable> T typedMarshallable() {
            try {
                CSVWire.this.consumeWhiteSpace();
                int code = CSVWire.this.peekCode();
                if (code < 0) {
                    throw new IllegalStateException("Cannot read nothing as a ReadMarshallable " + CSVWire.this.bytes.toDebugString());
                }
                StringBuilder sb = WireInternal.acquireStringBuilder();
                if (code != 33) {
                    throw new ClassCastException("Cannot convert to ReadMarshallable. " + CSVWire.this.bytes.toDebugString());
                }
                CSVWire.this.readCode();
                CSVWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
                if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!null")) {
                    this.text();
                    return null;
                }
                if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!binary")) {
                    this.bytesStore();
                    return null;
                }
                Class clazz = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                if (!ReadMarshallable.class.isAssignableFrom(clazz)) {
                    throw new ClassCastException("Cannot convert " + sb + " to ReadMarshallable.");
                }
                Class clazz1 = clazz;
                ReadMarshallable m = (ReadMarshallable)ObjectUtils.newInstance((Class)clazz1);
                this.marshallable(m);
                return (T)((ReadMarshallable)ReadResolvable.readResolve((Object)m));
            }
            catch (Exception e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        @Nullable
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            CSVWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (CSVWire.this.peekCode() == 33) {
                CSVWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if ("!!null".contentEquals(sb)) {
                    this.text();
                    return null;
                }
                if ("!!seqmap".contentEquals(sb)) {
                    CSVWire.this.consumeWhiteSpace();
                    int start = CSVWire.this.readCode();
                    if (start != 91) {
                        throw new IORuntimeException("Unsupported start of sequence : " + (char)start);
                    }
                    do {
                        this.marshallable(r -> {
                            Object k = r.read(() -> "key").object(kClazz);
                            Object v = r.read(() -> "value").object(vClass);
                            usingMap.put(k, v);
                        });
                    } while (this.hasNextSequenceItem());
                    return usingMap;
                }
                throw new IORuntimeException("Unsupported type :" + str);
            }
            return usingMap;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            CSVWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (CSVWire.this.peekCode() == 33) {
                CSVWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if ("!seqmap".contentEquals(sb)) {
                    while (this.hasNext()) {
                        this.sequence(usingMap, (map, s) -> s.marshallable(r -> {
                            try {
                                Object k = r.read(() -> "key").typedMarshallable();
                                Object v = r.read(() -> "value").typedMarshallable();
                                map.put(k, v);
                            }
                            catch (Exception e) {
                                TextWire.LOG.error("", (Throwable)e);
                            }
                        }));
                    }
                } else {
                    throw new IORuntimeException("Unsupported type " + str);
                }
            }
        }

        @Override
        public boolean bool() {
            CSVWire.this.consumeWhiteSpace();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                throw new NullPointerException("value is null");
            }
            return StringUtils.isEqual((CharSequence)sb, (CharSequence)"true");
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer" + ".MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            CSVWire.this.consumeWhiteSpace();
            return CSVWire.this.bytes.parseLong();
        }

        @Override
        public double float64() {
            CSVWire.this.consumeWhiteSpace();
            return CSVWire.this.bytes.parseDouble();
        }

        @Override
        public float float32() {
            double d = this.float64();
            if ((double)((float)d) != d) {
                throw new IllegalStateException("value=" + d + " can not be represented as a float");
            }
            return (float)d;
        }

        @Override
        public boolean isNull() {
            CSVWire.this.consumeWhiteSpace();
            if (CSVWire.this.peekStringIgnoreCase("!!null \"\"")) {
                CSVWire.this.bytes.readSkip((long)"!!null \"\"".length());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            return (E)ObjectUtils.convertTo(clazz, (Object)this.object0(using, clazz));
        }

        @Override
        @Nullable
        Object object0(@Nullable Object using, @NotNull Class clazz) {
            CSVWire.this.consumeWhiteSpace();
            if (this.isNull()) {
                return null;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return this.bytes();
            }
            if (BytesStore.class.isAssignableFrom(clazz)) {
                Bytes bytes = Bytes.wrapForRead((byte[])this.bytes());
                return bytes;
            }
            if (ReadMarshallable.class.isAssignableFrom(clazz)) {
                Object v = using == null ? ObjectUtils.newInstance((Class)clazz) : using;
                CSVWire.this.valueIn.marshallable((ReadMarshallable)v);
                return ReadResolvable.readResolve((Object)v);
            }
            if (StringBuilder.class.isAssignableFrom(clazz)) {
                StringBuilder builder = using == null ? WireInternal.acquireStringBuilder() : (StringBuilder)using;
                CSVWire.this.valueIn.textTo(builder);
                return using;
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return CSVWire.this.valueIn.text();
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return CSVWire.this.valueIn.int64();
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return CSVWire.this.valueIn.float64();
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return CSVWire.this.valueIn.int32();
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return Float.valueOf(CSVWire.this.valueIn.float32());
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return CSVWire.this.valueIn.int16();
            }
            if (Character.class.isAssignableFrom(clazz)) {
                String text = CSVWire.this.valueIn.text();
                if (text == null || text.length() == 0) {
                    return null;
                }
                return Character.valueOf(text.charAt(0));
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return CSVWire.this.valueIn.int8();
            }
            if (Map.class.isAssignableFrom(clazz)) {
                HashMap<String, String> result = new HashMap<String, String>();
                CSVWire.this.valueIn.map(result);
                return result;
            }
            return this.objectWithInferredType(clazz);
        }

        private Object typedObject() {
            Class clazz2;
            CSVWire.this.readCode();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            CSVWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
            try {
                clazz2 = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
            return this.object(null, clazz2);
        }

        @Override
        public String toString() {
            return CSVWire.this.toString();
        }
    }

    class CSVValueOut
    extends TextWire.TextValueOut {
        int indentation;
        @NotNull
        BytesStore sep;
        boolean leaf;

        CSVValueOut() {
            super(CSVWire.this);
            this.indentation = 0;
            this.sep = Bytes.empty();
            this.leaf = false;
        }

        @Override
        void prependSeparator() {
            CSVWire.this.append((CharSequence)this.sep);
            if (this.sep.endsWith('\n')) {
                this.indent();
            }
            this.sep = Bytes.empty();
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            this.leaf = true;
            return this;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return CSVWire.this;
        }

        private void indent() {
            for (int i = 0; i < this.indentation; ++i) {
                CSVWire.this.bytes.appendUtf8(32);
                CSVWire.this.bytes.appendUtf8(32);
            }
        }

        @Override
        public void elementSeparator() {
            if (this.indentation == 0) {
                this.sep = Bytes.empty();
                CSVWire.this.bytes.appendUtf8(10);
            } else {
                this.sep = this.leaf ? TextWire.COMMA_SPACE : TextWire.COMMA_NEW_LINE;
            }
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            this.prependSeparator();
            CSVWire.this.append(flag == null ? "!" + "!null \"\"" : (flag != false ? "true" : "false"));
            this.elementSeparator();
            return CSVWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            this.prependSeparator();
            if (s == null) {
                CSVWire.this.append("!!null \"\"");
            } else {
                CSVWire.this.escape(s);
            }
            this.elementSeparator();
            return CSVWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.prependSeparator();
            CSVWire.this.bytes.appendUtf8((int)i8);
            this.elementSeparator();
            return CSVWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (this.isText(fromBytes)) {
                return this.text(fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.readRemaining());
            byte[] byteArray = new byte[length];
            fromBytes.copyTo(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        @NotNull
        public WireOut rawBytes(@NotNull byte[] value) {
            this.prependSeparator();
            CSVWire.this.bytes.write(value);
            this.elementSeparator();
            return CSVWire.this;
        }

        private boolean isText(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return true;
            }
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        private void popState() {
            --this.indentation;
            this.leaf = false;
        }

        private void pushState() {
            ++this.indentation;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            if (!this.leaf) {
                this.pushState();
            }
            this.prependSeparator();
            CSVWire.this.bytes.appendUtf8(123);
            this.sep = this.leaf ? TextWire.SPACE : TextWire.END_FIELD;
            object.writeMarshallable(CSVWire.this);
            if (!this.leaf) {
                this.popState();
            } else {
                this.leaf = false;
            }
            if (this.sep.startsWith(',')) {
                CSVWire.this.append((CharSequence)this.sep, 1);
            } else {
                this.prependSeparator();
            }
            CSVWire.this.bytes.appendUtf8(125);
            if (this.indentation == 0) {
                this.sep = Bytes.empty();
                CSVWire.this.append((CharSequence)TextWire.NEW_LINE);
            } else {
                this.sep = TextWire.COMMA_NEW_LINE;
            }
            return CSVWire.this;
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            this.typePrefix("!seqmap");
            map.forEach((k, v) -> this.sequence(w -> w.marshallable(m -> m.write(() -> "key").typedMarshallable((WriteMarshallable)k).write(() -> "value").typedMarshallable((WriteMarshallable)v))));
            return CSVWire.this;
        }
    }

    static enum NoObject {
        NO_OBJECT;

    }
}

