/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.BinaryLongReference;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public enum WireType implements Function<Bytes, Wire>
{
    TEXT{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new TextWire(bytes);
        }

        @Override
        public Supplier<LongValue> newLongReference() {
            return TextLongReference::new;
        }

        @Override
        public Supplier<LongArrayValues> newLongArrayReference() {
            return TextLongArrayReference::new;
        }
    }
    ,
    BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes);
        }
    }
    ,
    FIELDLESS_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, true, Integer.MAX_VALUE, "binary");
        }
    }
    ,
    COMPRESSED_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, false, COMPRESSED_SIZE, "lzw");
        }
    }
    ,
    JSON{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new JSONWire(bytes);
        }
    }
    ,
    RAW{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new RawWire(bytes);
        }
    }
    ,
    READ_ANY{

        @Override
        public Wire apply(@NotNull Bytes bytes) {
            byte code = bytes.readByte(0L);
            if (code >= 32 && code < 127) {
                return (Wire)TEXT.apply(bytes);
            }
            if (BinaryWireCode.isFieldCode(code)) {
                return (Wire)FIELDLESS_BINARY.apply(bytes);
            }
            return (Wire)BINARY.apply(bytes);
        }
    };

    private static final int COMPRESSED_SIZE;

    public Supplier<LongValue> newLongReference() {
        return BinaryLongReference::new;
    }

    public Supplier<LongArrayValues> newLongArrayReference() {
        return BinaryLongArrayReference::new;
    }

    static {
        COMPRESSED_SIZE = Integer.getInteger("WireType.compressedSize", 128);
    }
}

