/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.EnumInterner;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.core.util.SerializableConsumer;
import net.openhft.chronicle.core.util.SerializableFunction;
import net.openhft.chronicle.core.util.SerializablePredicate;
import net.openhft.chronicle.core.util.SerializableUpdater;
import net.openhft.chronicle.core.util.SerializableUpdaterWithArg;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireSerializedLambda;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xerial.snappy.Snappy;

final class WireInternal
extends Enum<WireInternal> {
    public static final StringInterner INTERNER;
    static final StringBuilderPool SBP;
    static final StringBuilderPool ASBP;
    static final StackTraceElement[] NO_STE;
    private static final Field DETAILED_MESSAGE;
    private static final Field STACK_TRACE;
    private static final /* synthetic */ WireInternal[] $VALUES;

    public static WireInternal[] values() {
        return (WireInternal[])$VALUES.clone();
    }

    public static WireInternal valueOf(String name) {
        return Enum.valueOf(WireInternal.class, name);
    }

    public static <E extends Enum<E>> E internEnum(Class<E> eClass, CharSequence cs) {
        return (E)((EnumInterner)EnumInterner.ENUM_INTERNER.get(eClass)).intern(cs);
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static StringBuilder acquireAnotherStringBuilder(CharSequence cs) {
        StringBuilder sb = ASBP.acquireStringBuilder();
        assert (sb != cs);
        return sb;
    }

    public static void writeData(@NotNull WireOut wireOut, boolean metaData, boolean notReady, @NotNull WriteMarshallable writer) {
        Bytes<?> bytes = wireOut.bytes();
        long position = bytes.writePosition();
        int metaDataBit = metaData ? 0x40000000 : 0;
        bytes.writeOrderedInt(metaDataBit | Integer.MIN_VALUE | 0);
        writer.writeMarshallable(wireOut);
        int length = metaDataBit | Wires.toIntU30(bytes.writePosition() - position - 4L, "Document length %,d out of 30-bit int range.");
        bytes.writeOrderedInt(position, length | (notReady ? Integer.MIN_VALUE : 0));
    }

    public static void writeDataOnce(@NotNull WireOut wireOut, boolean metaData, @NotNull WriteMarshallable writer) {
        int metaDataBit;
        int value;
        long position;
        Bytes<?> bytes = wireOut.bytes();
        if (!bytes.compareAndSwapInt(position = bytes.writePosition(), 0, value = (metaDataBit = metaData ? 0x40000000 : 0) | Integer.MIN_VALUE | 0)) {
            return;
        }
        bytes.writeSkip(4L);
        writer.writeMarshallable(wireOut);
        int length = metaDataBit | Wires.toIntU30(bytes.writePosition() - position - 4L, "Document length %,d out of 30-bit int range.");
        if (!bytes.compareAndSwapInt(position, value, length | 0x40000000)) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readData(long offset, @NotNull WireIn wireIn, @Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) {
        Bytes<?> bytes = wireIn.bytes();
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readLimit(bytes.isElastic() ? bytes.capacity() : bytes.realCapacity());
            bytes.readPosition(offset);
            boolean bl = WireInternal.readData(wireIn, metaDataConsumer, dataConsumer);
            return bl;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readData(@NotNull WireIn wireIn, @Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) {
        Bytes<?> bytes = wireIn.bytes();
        boolean read = false;
        while (bytes.readRemaining() >= 4L) {
            long position = bytes.readPosition();
            int header = bytes.readVolatileInt(position);
            if (!WireInternal.isKnownLength(header)) {
                return read;
            }
            bytes.readSkip(4L);
            boolean ready = Wires.isReady(header);
            int len = Wires.lengthOf(header);
            if (Wires.isData(header)) {
                if (dataConsumer == null) {
                    return false;
                }
                ((InternalWireIn)wireIn).setReady(ready);
                bytes.readWithLength((long)len, b -> dataConsumer.readMarshallable(wireIn));
                return true;
            }
            if (metaDataConsumer == null) {
                bytes.readSkip((long)len);
            } else {
                if ((long)len > bytes.readRemaining()) {
                    throw new BufferUnderflowException();
                }
                long limit0 = bytes.readLimit();
                long limit = bytes.readPosition() + (long)len;
                try {
                    bytes.readLimit(limit);
                    metaDataConsumer.readMarshallable(wireIn);
                }
                finally {
                    bytes.readLimit(limit0);
                    bytes.readPosition(limit);
                }
            }
            if (dataConsumer == null) {
                return true;
            }
            read = true;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rawReadData(@NotNull WireIn wireIn, @NotNull ReadMarshallable dataConsumer) {
        Bytes<?> bytes = wireIn.bytes();
        int header = bytes.readInt();
        assert (Wires.isReady(header) && Wires.isData(header));
        int len = Wires.lengthOf(header);
        long limit0 = bytes.readLimit();
        long limit = bytes.readPosition() + (long)len;
        try {
            bytes.readLimit(limit);
            dataConsumer.readMarshallable(wireIn);
        }
        finally {
            bytes.readLimit(limit0);
        }
    }

    @Deprecated
    public static String fromSizePrefixedBinaryToText(@NotNull Bytes bytes) {
        return Wires.fromSizePrefixedBlobs(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String fromSizePrefixedBlobs(@NotNull Bytes bytes, long position, long length) {
        StringBuilder sb = new StringBuilder();
        long limit0 = bytes.readLimit();
        long position0 = bytes.readPosition();
        try {
            bytes.readPosition(position);
            long limit2 = Math.min(limit0, position + length);
            bytes.readLimit(limit2);
            long missing = position + length - limit2;
            while (bytes.readRemaining() >= 4L) {
                long header = bytes.readUnsignedInt();
                int len = Wires.lengthOf(header);
                if ((long)len > bytes.readRemaining()) {
                    throw new RuntimeException("Are you sure this was written with writeDocument and has a 4 byte size prefix, " + len + " > " + bytes.readRemaining());
                }
                String type = Wires.isData(header) ? (Wires.isReady(header) ? "!!data" : "!!not-ready-data!") : (Wires.isReady(header) ? "!!meta-data" : "!!not-ready-meta-data!");
                boolean binary = bytes.readByte(bytes.readPosition()) < 32;
                sb.append("--- ").append(type).append(binary ? " #binary" : "");
                if (missing > 0L) {
                    sb.append(" # missing: ").append(missing);
                }
                if ((long)len > bytes.readRemaining()) {
                    sb.append(" # len: ").append(len).append(", remaining: ").append(bytes.readRemaining());
                }
                sb.append("\n");
                Bytes textBytes = bytes;
                if (binary) {
                    Bytes bytes2 = Bytes.elasticByteBuffer();
                    TextWire textWire = new TextWire(bytes2);
                    long readLimit = bytes.readLimit();
                    try {
                        bytes.readLimit(bytes.readPosition() + (long)len);
                        new BinaryWire(bytes).copyTo(textWire);
                    }
                    finally {
                        bytes.readLimit(readLimit);
                    }
                    textBytes = bytes2;
                    len = (int)textBytes.readRemaining();
                }
                try {
                    for (int i = 0; i < len; ++i) {
                        int ch = textBytes.readUnsignedByte();
                        sb.append((char)ch);
                    }
                }
                catch (Exception e) {
                    sb.append(" ").append(e);
                }
                if (sb.charAt(sb.length() - 1) == '\n') continue;
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            bytes.readLimit(limit0);
            bytes.readPosition(position0);
        }
    }

    private static boolean isKnownLength(long len) {
        return (len & Integer.MAX_VALUE) != 0L;
    }

    public static Throwable throwable(@NotNull ValueIn valueIn, boolean appendCurrentStack) {
        Class type = valueIn.typePrefix();
        String preMessage = null;
        Throwable throwable = (Throwable)ObjectUtils.newInstance((Class)type);
        String finalPreMessage = preMessage;
        Throwable finalThrowable = throwable;
        ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>();
        valueIn.marshallable(m -> {
            String message = WireInternal.merge(finalPreMessage, m.read(() -> "message").text());
            if (message != null) {
                try {
                    DETAILED_MESSAGE.set(finalThrowable, message);
                }
                catch (IllegalAccessException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
            }
            m.read(() -> "stackTrace").sequence(stes, (stes0, stackTrace) -> {
                while (stackTrace.hasNextSequenceItem()) {
                    stackTrace.marshallable(r -> {
                        String declaringClass = r.read(() -> "class").text();
                        String methodName = r.read(() -> "method").text();
                        String fileName = r.read(() -> "file").text();
                        int lineNumber = r.read(() -> "line").int32();
                        stes0.add(new StackTraceElement(declaringClass, methodName, fileName, lineNumber));
                    });
                }
            });
        });
        if (appendCurrentStack) {
            stes.add(new StackTraceElement("~ remote", "tcp ~", "", 0));
            StackTraceElement[] stes2 = Thread.currentThread().getStackTrace();
            int first = 6;
            int last = Jvm.trimLast((int)first, (StackTraceElement[])stes2);
            for (int i = first; i <= last; ++i) {
                stes.add(stes2[i]);
            }
        }
        try {
            STACK_TRACE.set(finalThrowable, stes.toArray(NO_STE));
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return throwable;
    }

    @Nullable
    static String merge(@Nullable String a, @Nullable String b) {
        return a == null ? b : (b == null ? a : a + " " + b);
    }

    public static void compress(ValueOut out, String compression, Bytes bytes) {
        switch (compression) {
            case "snappy": {
                try {
                    out.bytes("snappy", Snappy.compress((byte[])bytes.toByteArray()));
                    break;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            case "gzip": {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gos = new GZIPOutputStream(baos);
                    bytes.copyTo((OutputStream)gos);
                    gos.close();
                    out.bytes("gzip", baos.toByteArray());
                    break;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown compression " + compression);
            }
        }
    }

    @Deprecated
    public static void compress(ValueOut out, String compression, String str) {
        if (compression.equals("snappy")) {
            try {
                out.bytes("snappy", Snappy.compress((String)str));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            throw new IllegalArgumentException("Unknown compression " + compression);
        }
    }

    static {
        $VALUES = new WireInternal[0];
        INTERNER = new StringInterner(128);
        SBP = new StringBuilderPool();
        ASBP = new StringBuilderPool();
        NO_STE = new StackTraceElement[0];
        DETAILED_MESSAGE = Jvm.getField(Throwable.class, (String)"detailMessage");
        STACK_TRACE = Jvm.getField(Throwable.class, (String)"stackTrace");
        ClassAliasPool.CLASS_ALIASES.addAlias(WireSerializedLambda.class, "SerializedLambda");
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{WireType.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableFunction.class, "Function");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableBiFunction.class, "BiFunction");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableConsumer.class, "Consumer");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializablePredicate.class, "Predicate");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableUpdater.class, "Updater");
        ClassAliasPool.CLASS_ALIASES.addAlias(SerializableUpdaterWithArg.class, "UpdaterWithArg");
    }
}

