/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;

class TextIntReference
implements IntValue,
Byteable {
    private static final byte[] template = "!!atomic { locked: false, value: 0000000000 }".getBytes();
    private static final int FALSE = 1936482662;
    private static final int TRUE = 1970435104;
    private static final int LOCKED = 19;
    private static final int VALUE = 33;
    private static final int DIGITS = 10;
    private BytesStore bytes;
    private long offset;

    TextIntReference() {
    }

    public static void write(@NotNull Bytes bytes, int value) {
        long position = bytes.writePosition();
        bytes.write(template);
        bytes.append(position + 33L, (long)value, 10);
    }

    private <T> T withLock(@NotNull Supplier<T> call) {
        long valueOffset = this.offset + 19L;
        int value = this.bytes.readVolatileInt(valueOffset);
        if (value != 1936482662 && value != 1970435104) {
            throw new IllegalStateException();
        }
        while (!this.bytes.compareAndSwapInt(valueOffset, 1936482662, 1970435104)) {
        }
        T t = call.get();
        this.bytes.writeOrderedInt(valueOffset, 1936482662);
        return t;
    }

    public int getValue() {
        return this.withLock(() -> (int)this.bytes.parseLong(this.offset + 33L));
    }

    public void setValue(int value) {
        this.withLock(() -> this.bytes.append(this.offset + 33L, (long)value, 10));
    }

    public int getVolatileValue() {
        return this.getValue();
    }

    public void setOrderedValue(int value) {
        this.setValue(value);
    }

    public int addValue(int delta) {
        return this.withLock(() -> {
            long value = this.bytes.parseLong(this.offset + 33L) + (long)delta;
            this.bytes.append(this.offset + 33L, value, 10);
            return (int)value;
        });
    }

    public int addAtomicValue(int delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(int expected, int value) {
        return this.withLock(() -> {
            if (this.bytes.parseLong(this.offset + 33L) == (long)expected) {
                this.bytes.append(this.offset + 33L, (long)value, 10);
                return true;
            }
            return false;
        });
    }

    public void bytesStore(BytesStore bytes, long offset, long length) {
        if (length != (long)template.length) {
            throw new IllegalArgumentException();
        }
        this.bytes = bytes;
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    public long offset() {
        return this.offset;
    }

    public long maxSize() {
        return template.length;
    }

    @NotNull
    public String toString() {
        return "value: " + this.getValue();
    }
}

