/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.IntTextReference;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextWire
implements Wire,
InternalWireIn {
    private static final Logger LOG = LoggerFactory.getLogger(TextWire.class);
    public static final String FIELD_SEP = "";
    private static final String END_FIELD = "\n";
    public static final String SEQ_MAP = "!seqmap";
    final Bytes<?> bytes;
    final TextValueOut valueOut = new TextValueOut();
    final ValueIn valueIn = new TextValueIn();
    boolean ready;
    static final BitSet QUOTE_CHARS = new BitSet();
    public static final String NULL = "!null \"\"";

    public TextWire(Bytes bytes) {
        this.bytes = bytes;
    }

    public static String asText(Wire wire) {
        TextWire tw = new TextWire((Bytes)NativeBytes.nativeBytes());
        wire.copyTo(tw);
        tw.flip();
        wire.flip();
        return tw.toString();
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueIn read() {
        this.readField(Wires.acquireStringBuilder());
        return this.valueIn;
    }

    private StringBuilder readField(StringBuilder sb) {
        this.consumeWhiteSpace();
        if (this.peekCode() == 44) {
            this.bytes.skip(1L);
            this.consumeWhiteSpace();
        }
        try {
            int ch = this.peekCode();
            if (ch == 34) {
                this.bytes.skip(1L);
                this.bytes.parseUTF((Appendable)sb, StopCharTesters.QUOTES.escaping());
                this.consumeWhiteSpace();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString());
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return sb;
                }
                this.bytes.parseUTF((Appendable)sb, TextStopCharsTesters.END_OF_TEXT.escaping());
            }
            TextWire.unescape(sb);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        return sb;
    }

    void consumeWhiteSpace() {
        int codePoint = this.peekCode();
        while (Character.isWhitespace(codePoint)) {
            this.bytes.skip(1L);
            codePoint = this.peekCode();
        }
    }

    int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.remaining() < 1L) {
            return false;
        }
        long pos = this.bytes.position();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.position(pos);
        }
        return true;
    }

    private int readCode() {
        if (this.bytes.remaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    public static <ACS extends Appendable & CharSequence> void unescape(ACS sb) {
        int end = 0;
        for (int i = 0; i < ((CharSequence)sb).length(); ++i) {
            int ch = ((CharSequence)sb).charAt(i);
            if (ch == 92 && i < ((CharSequence)sb).length() - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case 'n': {
                        ch = 10;
                    }
                }
            }
            BytesUtil.setCharAt(sb, (int)end++, (char)ch);
        }
        BytesUtil.setLength(sb, (int)end);
    }

    @Override
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.position();
        StringBuilder sb = this.readField(Wires.acquireStringBuilder());
        if (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name())) {
            return this.valueIn;
        }
        this.bytes.position(position);
        throw new UnsupportedOperationException("Unordered fields not supported yet. key=" + key.name() + ", was=" + sb + ", data='" + sb + "'");
    }

    @Override
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    public Wire readComment(@NotNull StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flip() {
        this.bytes.flip();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public ValueOut write() {
        return this.valueOut.write();
    }

    @Override
    public ValueOut write(WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    public ValueOut writeValue() {
        return this.valueOut;
    }

    @Override
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    public Wire writeComment(CharSequence s) {
        this.valueOut.writeComment(s);
        return this;
    }

    @Override
    public boolean hasDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.append((this.bytes.position() & 0x3FL) == 0L ? (char)'\n' : ' ');
        }
        return this;
    }

    CharSequence quotes(CharSequence s) {
        if (!this.needsQuotes(s)) {
            return s;
        }
        StringBuilder sb2 = Wires.acquireAnotherStringBuilder(s);
        sb2.append('\"');
        block4: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    sb2.append('\\').append(ch);
                    continue block4;
                }
                case '\n': {
                    sb2.append("\\n");
                    continue block4;
                }
                default: {
                    sb2.append(ch);
                }
            }
        }
        sb2.append('\"');
        return sb2;
    }

    boolean needsQuotes(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!QUOTE_CHARS.get(ch)) continue;
            return true;
        }
        return s.length() == 0;
    }

    static {
        for (char ch : "\",\n\\#:{}[]".toCharArray()) {
            QUOTE_CHARS.set(ch);
        }
    }

    static enum TextStopCharsTesters implements StopCharsTester
    {
        END_OF_TEXT{

            public boolean isStopChar(int ch, int ch2) throws IllegalStateException {
                if (ch == 34 || ch == 35 || ch == 10) {
                    return true;
                }
                return (ch == 58 || ch == 44) && ch2 <= 32;
            }
        };

    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        @NotNull
        public Wire bool(@NotNull BooleanConsumer flag) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (this.text(sb) == null) {
                flag.accept(null);
                return TextWire.this;
            }
            flag.accept(StringUtils.isEqual((CharSequence)sb, (CharSequence)"true"));
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireIn text(@NotNull Consumer<String> s) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            s.accept(sb.toString());
            return TextWire.this;
        }

        @Override
        public String text() {
            return StringUtils.toString((Object)this.text(Wires.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public <ACS extends Appendable & CharSequence> ACS text(@NotNull ACS a) {
            TextWire.this.consumeWhiteSpace();
            int ch = TextWire.this.peekCode();
            if (ch == 123) {
                long len = this.readLength();
                try {
                    a.append(Bytes.toDebugString(TextWire.this.bytes, (long)TextWire.this.bytes.position(), (long)len));
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                TextWire.this.bytes.skip(len);
                TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                return a;
            }
            if (ch == 34) {
                TextWire.this.bytes.skip(1L);
                TextWire.this.bytes.parseUTF(a, StopCharTesters.QUOTES.escaping());
                TextWire.unescape(a);
            } else if (ch == 33) {
                StringBuilder sb;
                TextWire.this.bytes.skip(1L);
                ch = TextWire.this.peekCode();
                if (ch == 33) {
                    TextWire.this.bytes.skip(1L);
                    sb = Wires.acquireStringBuilder();
                    TextWire.this.bytes.parseUTF((Appendable)sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                    if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"null")) {
                        this.text(sb);
                        return null;
                    }
                } else {
                    sb = Wires.acquireStringBuilder();
                    this.text(sb);
                }
            } else {
                if (TextWire.this.bytes.remaining() > 0L) {
                    if (a instanceof Bytes) {
                        TextWire.this.bytes.parse8bit(a, (StopCharsTester)TextStopCharsTesters.END_OF_TEXT);
                    } else {
                        TextWire.this.bytes.parseUTF(a, (StopCharsTester)TextStopCharsTesters.END_OF_TEXT);
                    }
                } else {
                    BytesUtil.setLength(a, (int)0);
                }
                while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                    BytesUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                }
            }
            int prev = this.rewindAndRead();
            if (prev == 58) {
                TextWire.this.bytes.skip(-1L);
            }
            return a;
        }

        private int rewindAndRead() {
            return TextWire.this.bytes.readUnsignedByte(TextWire.this.bytes.position() - 1L);
        }

        @Override
        @NotNull
        public Wire int8(@NotNull ByteConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((byte)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            return this.bytes((WireIn wi) -> toBytes.write(wi.bytes()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull Consumer<WireIn> bytesConsumer) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF((Appendable)sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (!str.equals("!!binary")) throw new IORuntimeException("Unsupported type " + str);
                BytesUtil.setLength((Appendable)sb, (int)0);
                TextWire.this.bytes.parseUTF((Appendable)sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                byte[] decode = Base64.getDecoder().decode(sb.toString());
                bytesConsumer.accept(new TextWire(Bytes.wrap((byte[])decode)));
                return TextWire.this;
            } else {
                this.text(sb);
                bytesConsumer.accept(new TextWire(Bytes.wrap((byte[])sb.toString().getBytes())));
            }
            return TextWire.this;
        }

        @Override
        public byte[] bytes() {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF((Appendable)sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (str.equals("!!binary")) {
                    BytesUtil.setLength((Appendable)sb, (int)0);
                    TextWire.this.bytes.parseUTF((Appendable)sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                    byte[] decode = Base64.getDecoder().decode(sb.toString());
                    return decode;
                }
                if (str.equals("!!seqmap")) {
                    sb.append(TextWire.this.bytes.toString());
                    return sb.toString().getBytes();
                }
                throw new IllegalStateException("unsupported type");
            }
            this.text(sb);
            return sb.toString().getBytes();
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            TextWire.this.consumeWhiteSpace();
            long start = TextWire.this.bytes.position();
            try {
                TextWire.this.consumeWhiteSpace();
                int code = TextWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b != 125 || --count != 0) continue;
                            long l = TextWire.this.bytes.position() - start;
                            return l;
                        }
                    }
                    case 45: {
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 10) {
                                long l = TextWire.this.bytes.position() - start + 1L;
                                return l;
                            }
                            if (TextWire.this.bytes.remaining() != 0L) continue;
                            long l = TextWire.this.bytes.limit() - start;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = TextWire.this.bytes.position() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.position(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long readLengthMarshable() {
            long start = TextWire.this.bytes.position();
            try {
                TextWire.this.consumeWhiteSpace();
                int code = TextWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b != 125 || --count != 0) continue;
                            long l = TextWire.this.bytes.position() - start;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = TextWire.this.bytes.position() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.position(start);
            }
        }

        @Override
        @NotNull
        public Wire uint8(@NotNull ShortConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((short)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire int16(@NotNull ShortConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((short)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire uint16(@NotNull IntConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((int)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire int32(@NotNull IntConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((int)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire uint32(@NotNull LongConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept(TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire int64(@NotNull LongConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept(TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire float32(@NotNull FloatConsumer v) {
            TextWire.this.consumeWhiteSpace();
            v.accept((float)TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire float64(@NotNull DoubleConsumer v) {
            TextWire.this.consumeWhiteSpace();
            v.accept(TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire time(@NotNull Consumer<LocalTime> localTime) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            localTime.accept(LocalTime.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire zonedDateTime(@NotNull Consumer<ZonedDateTime> zonedDateTime) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            zonedDateTime.accept(ZonedDateTime.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire date(@NotNull Consumer<LocalDate> localDate) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            localDate.accept(LocalDate.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        public boolean hasNext() {
            return TextWire.this.bytes.remaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            TextWire.this.consumeWhiteSpace();
            int ch = TextWire.this.peekCode();
            if (ch == 44) {
                TextWire.this.bytes.skip(1L);
                return true;
            }
            return ch != 93;
        }

        @Override
        public WireIn uuid(@NotNull Consumer<UUID> uuid) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            uuid.accept(UUID.fromString(sb.toString()));
            return TextWire.this;
        }

        @Override
        public WireIn int64array(@Nullable LongArrayValues values, @NotNull Consumer<LongArrayValues> setter) {
            TextWire.this.consumeWhiteSpace();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
                setter.accept(values);
            }
            Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength(TextWire.this.bytes, TextWire.this.bytes.position());
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            return TextWire.this;
        }

        @Override
        public WireIn int64(LongValue value, @NotNull Consumer<LongValue> setter) {
            TextWire.this.consumeWhiteSpace();
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            TextWire.this.consumeWhiteSpace();
            if (TextWire.this.peekCode() == 44) {
                TextWire.this.bytes.skip(1L);
            }
            return TextWire.this;
        }

        @Override
        public WireIn int32(IntValue value, @NotNull Consumer<IntValue> setter) {
            if (!(value instanceof IntTextReference)) {
                value = new IntTextReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            TextWire.this.consumeWhiteSpace();
            if (TextWire.this.peekCode() == 44) {
                TextWire.this.bytes.skip(1L);
            }
            return TextWire.this;
        }

        @Override
        public WireIn sequence(@NotNull Consumer<ValueIn> reader) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.readCode();
            if (code != 91) {
                throw new IORuntimeException("Unsupported type " + (char)code + " (" + code + ")");
            }
            reader.accept(TextWire.this.valueIn);
            TextWire.this.consumeWhiteSpace();
            code = TextWire.this.peekCode();
            if (code != 93) {
                throw new IORuntimeException("Expected a ] but got " + (char)code + " (" + code + ")");
            }
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(Function<WireIn, T> marshallableReader) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshable() - 1L;
            long limit = TextWire.this.bytes.limit();
            long position = TextWire.this.bytes.position();
            try {
                long newLimit = position - 1L + len;
                TextWire.this.bytes.limit(newLimit);
                TextWire.this.bytes.skip(1L);
                TextWire.this.consumeWhiteSpace();
                T t = marshallableReader.apply(TextWire.this);
                return t;
            }
            finally {
                TextWire.this.bytes.limit(limit);
                TextWire.this.consumeWhiteSpace();
                code = TextWire.this.readCode();
                if (code != 125) {
                    throw new IORuntimeException("Unterminated { while reading marshallable bytes=" + Bytes.toDebugString(TextWire.this.bytes));
                }
            }
        }

        @Override
        @NotNull
        public Wire type(@NotNull StringBuilder s) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.readCode();
            if (code != 33) {
                throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
            }
            TextWire.this.bytes.parseUTF((Appendable)s, (StopCharTester)StopCharTesters.SPACE_STOP);
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                this.type(Wires.acquireStringBuilder());
            } else if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshable() - 1L;
            long limit = TextWire.this.bytes.limit();
            long position = TextWire.this.bytes.position();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.limit(newLimit);
                TextWire.this.bytes.skip(1L);
                TextWire.this.consumeWhiteSpace();
                object.readMarshallable(TextWire.this);
            }
            finally {
                TextWire.this.bytes.limit(limit);
                TextWire.this.bytes.position(newLimit);
            }
            TextWire.this.consumeWhiteSpace();
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toDebugString(TextWire.this.bytes));
            }
            return TextWire.this;
        }

        @Override
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            TextWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF((Appendable)sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if ("!!null".contentEquals(sb)) {
                    this.text();
                    return null;
                }
                if ("!!seqmap".contentEquals(sb)) {
                    TextWire.this.consumeWhiteSpace();
                    int start = TextWire.this.readCode();
                    if (start != 91) {
                        throw new IORuntimeException("Unsupported start of sequence : " + (char)start);
                    }
                    do {
                        this.marshallable(r -> {
                            Object k = r.read(() -> "key").object(kClazz);
                            Object v = r.read(() -> "value").object(vClass);
                            usingMap.put(k, v);
                        });
                    } while (this.hasNextSequenceItem());
                    return usingMap;
                }
                throw new IORuntimeException("Unsupported type :" + str);
            }
            return usingMap;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            TextWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF((Appendable)sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (TextWire.SEQ_MAP.contentEquals(sb)) {
                    while (this.hasNext()) {
                        this.sequence(s -> s.marshallable(r -> {
                            try {
                                ReadMarshallable k = r.read(() -> "key").typedMarshallable();
                                ReadMarshallable v = r.read(() -> "value").typedMarshallable();
                                usingMap.put(k, v);
                            }
                            catch (Exception e) {
                                LOG.error(TextWire.FIELD_SEP, (Throwable)e);
                            }
                        }));
                    }
                } else {
                    throw new IORuntimeException("Unsupported type " + str);
                }
            }
        }

        @Override
        public boolean bool() {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (this.text(sb) == null) {
                throw new NullPointerException("value is null");
            }
            return StringUtils.isEqual((CharSequence)sb, (CharSequence)"true");
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer" + ".MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            TextWire.this.consumeWhiteSpace();
            return TextWire.this.bytes.parseLong();
        }

        @Override
        public double float64() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public float float32() {
            throw new UnsupportedOperationException("todo");
        }

        public boolean isNull() {
            TextWire.this.consumeWhiteSpace();
            if (TextWire.this.peekStringIgnoreCase("!!null \"\"")) {
                TextWire.this.bytes.skip((long)"!!null \"\"".length());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            TextWire.this.consumeWhiteSpace();
            if (this.isNull()) {
                return null;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return (E)this.bytes();
            }
            if (Marshallable.class.isAssignableFrom(clazz)) {
                Object v = using == null ? OS.memory().allocateInstance(clazz) : using;
                TextWire.this.valueIn.marshallable((Marshallable)v);
                return v;
            }
            if (StringBuilder.class.isAssignableFrom(clazz)) {
                StringBuilder builder = using == null ? Wires.acquireStringBuilder() : (StringBuilder)using;
                TextWire.this.valueIn.text(builder);
                return using;
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return (E)TextWire.this.valueIn.text();
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return (E)Long.valueOf(TextWire.this.valueIn.int64());
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return (E)Double.valueOf(TextWire.this.valueIn.float64());
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return (E)Integer.valueOf(TextWire.this.valueIn.int32());
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return (E)Float.valueOf(TextWire.this.valueIn.float32());
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return (E)Short.valueOf(TextWire.this.valueIn.int16());
            }
            if (Character.class.isAssignableFrom(clazz)) {
                String text = TextWire.this.valueIn.text();
                if (text == null || text.length() == 0) {
                    return null;
                }
                return (E)Character.valueOf(text.charAt(0));
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return (E)Byte.valueOf(TextWire.this.valueIn.int8());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                HashMap<String, String> result = new HashMap<String, String>();
                TextWire.this.valueIn.map(result);
                return (E)result;
            }
            throw new IllegalStateException("unsupported type=" + clazz);
        }
    }

    class TextValueOut
    implements ValueOut {
        int indentation = 0;
        String sep = "";
        boolean leaf = false;

        TextValueOut() {
        }

        void prependSeparator() {
            TextWire.this.bytes.append((CharSequence)this.sep);
            if (this.sep.endsWith(TextWire.END_FIELD)) {
                this.indent();
            }
            this.sep = TextWire.FIELD_SEP;
        }

        @Override
        public ValueOut leaf() {
            this.leaf = true;
            return this;
        }

        @Override
        public WireOut wireOut() {
            return TextWire.this;
        }

        private void indent() {
            for (int i = 0; i < this.indentation; ++i) {
                TextWire.this.bytes.append((CharSequence)"  ");
            }
        }

        public void elementSeparator() {
            if (this.indentation == 0) {
                this.sep = TextWire.FIELD_SEP;
                TextWire.this.bytes.append((CharSequence)TextWire.END_FIELD);
            } else {
                this.sep = this.leaf ? ", " : ",\n";
            }
        }

        @Override
        public Wire bool(Boolean flag) {
            this.prependSeparator();
            TextWire.this.bytes.append((CharSequence)(flag == null ? "!" + TextWire.NULL : (flag != false ? "true" : "false")));
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire text(CharSequence s) {
            this.prependSeparator();
            TextWire.this.bytes.append(s == null ? "!" + TextWire.NULL : TextWire.this.quotes(s));
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire int8(byte i8) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)i8);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public WireOut bytes(Bytes fromBytes) {
            if (this.isText(fromBytes)) {
                return this.text((CharSequence)fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.remaining());
            byte[] byteArray = new byte[length];
            fromBytes.read(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        public WireOut rawBytes(byte[] value) {
            this.prependSeparator();
            TextWire.this.bytes.write(value);
            this.elementSeparator();
            return TextWire.this;
        }

        private boolean isText(Bytes fromBytes) {
            for (long i = fromBytes.position(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireOut bytes(byte[] byteArray) {
            this.prependSeparator();
            ((Bytes)((Bytes)TextWire.this.bytes.append((CharSequence)"!!binary ")).append((CharSequence)Base64.getEncoder().encodeToString(byteArray))).append((CharSequence)TextWire.END_FIELD);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire uint8checked(int u8) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)u8);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire int16(short i16) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)i16);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire uint16checked(int u16) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)u16);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire utf8(int codepoint) {
            this.prependSeparator();
            StringBuilder sb = Wires.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            this.sep = TextWire.FIELD_SEP;
            return TextWire.this;
        }

        @Override
        public Wire int32(int i32) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)i32);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire uint32checked(long u32) {
            this.prependSeparator();
            TextWire.this.bytes.append(u32);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire int64(long i64) {
            this.prependSeparator();
            TextWire.this.bytes.append(i64);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public WireOut int64array(long capacity) {
            TextLongArrayReference.write(TextWire.this.bytes, capacity);
            return TextWire.this;
        }

        @Override
        public Wire float32(float f) {
            this.prependSeparator();
            TextWire.this.bytes.append(f);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire float64(double d) {
            this.prependSeparator();
            TextWire.this.bytes.append(d);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire time(LocalTime localTime) {
            this.prependSeparator();
            TextWire.this.bytes.append((CharSequence)localTime.toString());
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire zonedDateTime(ZonedDateTime zonedDateTime) {
            this.prependSeparator();
            TextWire.this.bytes.append((CharSequence)zonedDateTime.toString());
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire date(LocalDate localDate) {
            this.prependSeparator();
            TextWire.this.bytes.append((CharSequence)localDate.toString());
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public Wire type(CharSequence typeName) {
            this.prependSeparator();
            ((Bytes)TextWire.this.bytes.append('!')).append(typeName);
            this.sep = " ";
            return TextWire.this;
        }

        @Override
        public WireOut uuid(UUID uuid) {
            this.prependSeparator();
            ((Bytes)TextWire.this.bytes.append((CharSequence)this.sep)).append((CharSequence)uuid.toString());
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public WireOut int32forBinding(int value) {
            this.prependSeparator();
            IntTextReference.write(TextWire.this.bytes, value);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public WireOut int64forBinding(long value) {
            this.prependSeparator();
            TextLongReference.write(TextWire.this.bytes, value);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        public WireOut sequence(Consumer<ValueOut> writer) {
            this.pushState();
            TextWire.this.bytes.append((CharSequence)"[");
            this.sep = TextWire.END_FIELD;
            long pos = TextWire.this.bytes.position();
            writer.accept(this);
            if (pos != TextWire.this.bytes.position()) {
                TextWire.this.bytes.append((CharSequence)TextWire.END_FIELD);
            }
            this.popState();
            this.indent();
            TextWire.this.bytes.append((CharSequence)"]");
            this.sep = TextWire.END_FIELD;
            return TextWire.this;
        }

        private void popState() {
            --this.indentation;
            this.leaf = false;
        }

        private void pushState() {
            ++this.indentation;
        }

        @Override
        public WireOut marshallable(WriteMarshallable object) {
            if (!this.leaf) {
                this.pushState();
            }
            this.prependSeparator();
            TextWire.this.bytes.append((CharSequence)"{");
            this.sep = this.leaf ? " " : TextWire.END_FIELD;
            object.writeMarshallable(TextWire.this);
            if (!this.leaf) {
                this.popState();
            } else {
                this.leaf = false;
            }
            if (this.sep.startsWith(",")) {
                TextWire.this.bytes.append((CharSequence)this.sep.substring(1));
            } else {
                this.prependSeparator();
            }
            TextWire.this.bytes.append('}');
            if (this.indentation == 0) {
                this.sep = TextWire.FIELD_SEP;
                TextWire.this.bytes.append((CharSequence)TextWire.END_FIELD);
            } else {
                this.sep = ",\n";
            }
            return TextWire.this;
        }

        @Override
        public WireOut map(@NotNull Map map) {
            this.type(TextWire.SEQ_MAP);
            TextWire.this.bytes.append((CharSequence)" [");
            this.pushState();
            this.sep = TextWire.END_FIELD;
            map.forEach((k, v) -> {
                this.prependSeparator();
                TextWire.this.bytes.append((CharSequence)"{ key: ");
                this.leaf();
                this.object2(k);
                this.sep = ",\n";
                this.prependSeparator();
                TextWire.this.bytes.append((CharSequence)"  value: ");
                this.leaf();
                this.object2(v);
                TextWire.this.bytes.append((CharSequence)" }");
                this.sep = ",\n";
            });
            this.popState();
            this.sep = TextWire.END_FIELD;
            this.prependSeparator();
            TextWire.this.bytes.append((CharSequence)"]");
            this.sep = TextWire.END_FIELD;
            return TextWire.this;
        }

        private void object2(Object v) {
            if (v instanceof CharSequence) {
                this.text((CharSequence)v);
            } else if (v instanceof WriteMarshallable) {
                this.typedMarshallable((WriteMarshallable)v);
            } else if (v == null) {
                TextWire.this.bytes.append((CharSequence)"!!null \"\"");
            } else {
                this.text(String.valueOf(v));
            }
        }

        @Override
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            this.type(TextWire.SEQ_MAP);
            map.forEach((k, v) -> this.sequence(w -> w.marshallable(m -> m.write(() -> "key").typedMarshallable((WriteMarshallable)k).write(() -> "value").typedMarshallable((WriteMarshallable)v))));
            return TextWire.this;
        }

        public ValueOut write() {
            ((Bytes)TextWire.this.bytes.append((CharSequence)this.sep)).append((CharSequence)"\"\": ");
            this.sep = TextWire.FIELD_SEP;
            return this;
        }

        public ValueOut write(WireKey key) {
            CharSequence name = key.name();
            if (name == null) {
                name = Integer.toString(key.code());
            }
            this.prependSeparator();
            ((Bytes)TextWire.this.bytes.append(TextWire.this.quotes(name))).append((CharSequence)": ");
            return this;
        }

        public void writeComment(CharSequence s) {
            this.prependSeparator();
            ((Bytes)((Bytes)((Bytes)TextWire.this.bytes.append((CharSequence)this.sep)).append((CharSequence)"# ")).append(s)).append((CharSequence)TextWire.END_FIELD);
            this.sep = TextWire.FIELD_SEP;
        }
    }
}

