/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.BinaryLongReference;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.IntBinaryReference;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryWire
implements Wire,
InternalWireIn {
    public static final int ANY_CODE_MATCH = -1;
    static final int END_OF_BYTES = -1;
    final Bytes<?> bytes;
    final ValueOut fixedValueOut = new FixedBinaryValueOut();
    final ValueOut valueOut;
    final ValueIn valueIn = new BinaryValueIn();
    private final boolean numericFields;
    private final boolean fieldLess;
    boolean ready;

    public BinaryWire(Bytes bytes) {
        this(bytes, false, false, false);
    }

    public BinaryWire(Bytes bytes, boolean fixed, boolean numericFields, boolean fieldLess) {
        this.numericFields = numericFields;
        this.fieldLess = fieldLess;
        this.bytes = bytes;
        this.valueOut = fixed ? this.fixedValueOut : new BinaryValueOut();
    }

    static int toIntU30(long l, String error) {
        if (l < 0L || l > 0x3FFFFFFFL) {
            throw new IllegalStateException(String.format(error, l));
        }
        return (int)l;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        while (this.bytes.remaining() > 0L) {
            int peekCode = this.peekCode();
            block0 : switch (peekCode >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.bytes.skip(1L);
                    wire.writeValue().uint8(peekCode);
                    break;
                }
                case 8: {
                    switch (peekCode) {
                        case 143: {
                            this.bytes.skip(1L);
                            break block0;
                        }
                        case 142: {
                            this.bytes.skip(1L);
                            this.bytes.skip(this.bytes.readUnsignedInt());
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case 9: {
                    this.bytes.skip(1L);
                    double d = this.readFloat0(peekCode);
                    wire.writeValue().float64(d);
                    break;
                }
                case 10: {
                    this.bytes.skip(1L);
                    long l = this.readInt0(peekCode);
                    wire.writeValue().int64(l);
                    break;
                }
                case 11: {
                    this.copySpecial(wire, peekCode);
                    break;
                }
                case 12: 
                case 13: {
                    StringBuilder fsb = this.readField(peekCode, -1, Wires.acquireStringBuilder());
                    wire.write(() -> fsb);
                    break;
                }
                case 14: 
                case 15: {
                    this.bytes.skip(1L);
                    StringBuilder sb = this.readText(peekCode, Wires.acquireStringBuilder());
                    wire.writeValue().text(sb);
                }
            }
        }
    }

    @Override
    public ValueIn read() {
        this.readField(Wires.acquireStringBuilder(), -1);
        return this.valueIn;
    }

    @Override
    public ValueIn read(@NotNull WireKey key) {
        StringBuilder sb = this.readField(Wires.acquireStringBuilder(), key.code());
        if (this.fieldLess || sb != null && (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name()))) {
            return this.valueIn;
        }
        throw new UnsupportedOperationException("Unordered fields not supported yet, Expected=" + key.name() + " was: " + sb);
    }

    @Override
    public ValueIn readEventName(@NotNull StringBuilder name) {
        this.readField(name, -1);
        return this.valueIn;
    }

    @Override
    public ValueIn read(@NotNull StringBuilder name) {
        this.readField(name, -1);
        return this.valueIn;
    }

    @Override
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    public Wire readComment(@NotNull StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flip() {
        this.bytes.flip();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    public Bytes<?> bytes() {
        return this.bytes;
    }

    private StringBuilder readField(StringBuilder name, int codeMatch) {
        this.consumeSpecial();
        int peekCode = this.peekCode();
        return this.readField(peekCode, codeMatch, name);
    }

    private void consumeSpecial() {
        block6: while (true) {
            int code = this.peekCode();
            switch (code) {
                case 143: {
                    this.bytes.skip(1L);
                    continue block6;
                }
                case 142: {
                    this.bytes.skip(1L);
                    this.bytes.skip(this.bytes.readUnsignedInt());
                    continue block6;
                }
                case 190: {
                    this.bytes.skip(1L);
                    StringBuilder sb = Wires.acquireStringBuilder();
                    this.bytes.readUTF\u0394((Appendable)sb);
                    continue block6;
                }
                case 191: {
                    this.bytes.skip(1L);
                    StringBuilder sb = Wires.acquireStringBuilder();
                    this.bytes.readUTF\u0394((Appendable)sb);
                    continue block6;
                }
            }
            break;
        }
    }

    private int peekCode() {
        if (this.bytes.remaining() < 1L) {
            return -1;
        }
        long pos = this.bytes.position();
        return this.bytes.readUnsignedByte(pos);
    }

    private StringBuilder readField(int peekCode, int codeMatch, StringBuilder sb) {
        switch (peekCode >> 4) {
            case -1: {
                sb.setLength(0);
                break;
            }
            case 11: {
                if (peekCode == 183 || peekCode == 185) {
                    this.bytes.skip(1L);
                    this.bytes.readUTF\u0394((Appendable)sb);
                    return sb;
                }
                if (peekCode == 186) {
                    this.bytes.skip(1L);
                    long fieldId = this.bytes.readStopBit();
                    if (codeMatch >= 0 && fieldId != (long)codeMatch) {
                        throw new UnsupportedOperationException("Field was: " + fieldId + " expected " + codeMatch);
                    }
                    if (codeMatch < 0) {
                        sb.append(fieldId);
                    }
                    return sb;
                }
                return null;
            }
            case 12: 
            case 13: {
                this.bytes.skip(1L);
                return this.getStringBuilder(peekCode, sb);
            }
        }
        if (this.fieldLess) {
            sb.setLength(0);
            return sb;
        }
        return null;
    }

    private <ACS extends Appendable & CharSequence> ACS getStringBuilder(int code, ACS sb) {
        BytesUtil.setLength(sb, (int)0);
        BytesUtil.parseUTF(this.bytes, sb, (int)(code & 0x1F));
        return sb;
    }

    private void copySpecial(WireOut wire, int peekCode) {
        switch (peekCode) {
            case 190: {
                this.bytes.skip(1L);
                StringBuilder sb = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb);
                wire.writeComment(sb);
                break;
            }
            case 191: {
                this.bytes.skip(1L);
                StringBuilder sb = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb);
                break;
            }
            case 178: 
            case 180: 
            case 181: {
                throw new UnsupportedOperationException();
            }
            case 182: {
                this.bytes.skip(1L);
                StringBuilder sb = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb);
                wire.writeValue().type(sb);
                break;
            }
            case 183: {
                StringBuilder fsb = this.readField(peekCode, -1, Wires.acquireStringBuilder());
                wire.write(() -> fsb);
                break;
            }
            case 184: {
                this.bytes.skip(1L);
                StringBuilder sb = this.readText(peekCode, Wires.acquireStringBuilder());
                wire.writeValue().text(sb);
                break;
            }
            case 186: {
                this.bytes.skip(1L);
                final long code2 = this.bytes.readStopBit();
                wire.write(new WireKey(){

                    @Override
                    public String name() {
                        return null;
                    }

                    @Override
                    public int code() {
                        return (int)code2;
                    }
                });
                break;
            }
            case 187: {
                this.bytes.skip(1L);
                wire.writeValue().bool(null);
                break;
            }
            case 176: {
                this.bytes.skip(1L);
                wire.writeValue().bool(false);
                break;
            }
            case 177: {
                this.bytes.skip(1L);
                wire.writeValue().bool(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(BinaryWireCode.stringForCode(peekCode));
            }
        }
    }

    long readInt(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 11: {
                switch (code) {
                    case 176: {
                        return 0L;
                    }
                    case 177: {
                        return 1L;
                    }
                }
                break;
            }
            case 9: {
                double d = this.readFloat0(code);
                return (long)d;
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private double readFloat0(int code) {
        switch (code) {
            case 144: {
                return this.bytes.readFloat();
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    long readInt0(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private boolean isSmallInt(int code) {
        return (code & 0x80) == 0;
    }

    private double readFloat(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 9: {
                return this.readFloat0(code);
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    @Override
    public ValueOut write() {
        if (!this.fieldLess) {
            this.writeField("");
        }
        return this.valueOut;
    }

    @Override
    public ValueOut writeEventName(WireKey key) {
        this.writeCode(185).writeUTF\u0394(key.name());
        return this.valueOut;
    }

    @Override
    public ValueOut write(WireKey key) {
        if (!this.fieldLess) {
            if (this.numericFields) {
                this.writeField(key.code());
            } else {
                this.writeField(key.name());
            }
        }
        return this.valueOut;
    }

    @Override
    public ValueOut writeValue() {
        return this.valueOut;
    }

    @Override
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    public Wire writeComment(CharSequence s) {
        this.writeCode(190);
        this.bytes.writeUTF\u0394(s);
        return this;
    }

    @Override
    public boolean hasDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WireOut addPadding(int paddingToAdd) {
        if (paddingToAdd < 0) {
            throw new IllegalStateException("Cannot add " + paddingToAdd + " bytes of padding");
        }
        if (paddingToAdd >= 5) {
            this.writeCode(142).writeUnsignedInt((long)(paddingToAdd - 5)).skip((long)(paddingToAdd - 5));
        } else {
            for (int i = 0; i < paddingToAdd; ++i) {
                this.writeCode(143);
            }
        }
        return this;
    }

    private void writeField(CharSequence name) {
        int len = name.length();
        if (len < 32) {
            if (len > 0 && Character.isDigit(name.charAt(0))) {
                try {
                    this.writeField(Integer.parseInt(name.toString()));
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ((Bytes)this.bytes.writeByte((byte)(192 + len))).append(name);
        } else {
            this.writeCode(183).writeUTF\u0394(name);
        }
    }

    private void writeField(int code) {
        this.writeCode(186);
        this.bytes.writeStopBit((long)code);
    }

    private Bytes writeCode(int code) {
        return (Bytes)this.bytes.writeByte((byte)code);
    }

    <ACS extends Appendable & CharSequence> ACS readText(int code, ACS sb) {
        if (code <= 127) {
            BytesUtil.append(sb, (long)code);
            return sb;
        }
        switch (code >> 4) {
            case 11: {
                switch (code) {
                    case 187: {
                        BytesUtil.append(sb, (String)"null");
                        return sb;
                    }
                    case 177: {
                        BytesUtil.append(sb, (String)"true");
                        return sb;
                    }
                    case 176: {
                        BytesUtil.append(sb, (String)"false");
                        return sb;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 184: {
                        this.bytes.readUTF\u0394(sb);
                        return sb;
                    }
                }
                return null;
            }
            case 9: {
                BytesUtil.append(sb, (double)this.readFloat(code));
                return sb;
            }
            case 10: {
                BytesUtil.append(sb, (long)this.readInt(code));
                return sb;
            }
            case 14: 
            case 15: {
                return this.getStringBuilder(code, sb);
            }
        }
        throw new UnsupportedOperationException("code=0x" + String.format("%02X ", code).trim());
    }

    private int readCode() {
        if (this.bytes.remaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    public String toString() {
        return this.bytes.toDebugString(this.bytes.capacity());
    }

    class BinaryValueIn
    implements ValueIn {
        BinaryValueIn() {
        }

        @Override
        @NotNull
        public WireIn bool(@NotNull BooleanConsumer flag) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    flag.accept(null);
                    break;
                }
                case 176: {
                    flag.accept(false);
                    break;
                }
                case 177: {
                    flag.accept(true);
                    break;
                }
                default: {
                    return this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn text(@NotNull Consumer<String> s) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    s.accept(null);
                    break;
                }
                case 184: {
                    s.accept(BinaryWire.this.bytes.readUTF\u0394());
                    break;
                }
                default: {
                    if (code >= 224 && code <= 255) {
                        StringBuilder sb = Wires.acquireStringBuilder();
                        BytesUtil.parseUTF(BinaryWire.this.bytes, (Appendable)sb, (int)(code & 0x1F));
                        s.accept(sb.toString());
                        break;
                    }
                    this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        private boolean isText(int code) {
            return code == 184 || code >= 224 && code <= 255;
        }

        @Override
        @Nullable
        public <ACS extends Appendable & CharSequence> ACS text(@NotNull ACS s) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                BytesUtil.setLength(s, (int)0);
                return null;
            }
            ACS text = BinaryWire.this.readText(code, s);
            if (text == null) {
                this.cantRead(code);
            }
            return s;
        }

        @Override
        @NotNull
        public WireIn int8(@NotNull ByteConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.bytes.readUnsignedByte();
            if (this.isText(code)) {
                i.accept(Byte.valueOf(this.text()));
            } else {
                i.accept((byte)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            BinaryWire.this.bytes.withLength(length - 1L, arg_0 -> ((Bytes)toBytes).write(arg_0));
            return this.wireIn();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull Consumer<WireIn> bytesConsumer) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (length > BinaryWire.this.bytes.remaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = BinaryWire.this.bytes.limit();
            long limit = BinaryWire.this.bytes.position() + length;
            try {
                BinaryWire.this.bytes.limit(limit);
                bytesConsumer.accept(this.wireIn());
            }
            finally {
                BinaryWire.this.bytes.limit(limit0);
                BinaryWire.this.bytes.position(limit);
            }
            return this.wireIn();
        }

        @Override
        public byte[] bytes() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return BinaryWire.this;
        }

        @Override
        public long readLength() {
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 130: {
                    BinaryWire.this.bytes.skip(1L);
                    return BinaryWire.this.bytes.readUnsignedInt();
                }
            }
            return -1L;
        }

        @Override
        @NotNull
        public WireIn uint8(@NotNull ShortConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Short.valueOf(this.text()));
            } else {
                i.accept((short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int16(@NotNull ShortConsumer i) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Short.valueOf(this.text()));
            } else {
                i.accept((short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn uint16(@NotNull IntConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Integer.valueOf(this.text()));
            } else {
                i.accept((int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Integer.valueOf(this.text()));
            } else {
                i.accept((int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn uint32(@NotNull LongConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Long.valueOf(this.text()));
            } else {
                i.accept(BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongConsumer i) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Long.valueOf(this.text()));
            } else {
                i.accept(BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn float32(@NotNull FloatConsumer v) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                v.accept(Float.valueOf(this.text()).floatValue());
            } else {
                v.accept((float)BinaryWire.this.readFloat(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn float64(@NotNull DoubleConsumer v) {
            int code = BinaryWire.this.readCode();
            v.accept(BinaryWire.this.readFloat(code));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn time(@NotNull Consumer<LocalTime> localTime) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 178) {
                localTime.accept(this.readLocalTime());
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        private LocalTime readLocalTime() {
            StringBuilder sb = Wires.acquireStringBuilder();
            BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
            return LocalTime.parse(sb);
        }

        @Override
        @NotNull
        public WireIn zonedDateTime(@NotNull Consumer<ZonedDateTime> zonedDateTime) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 181) {
                StringBuilder sb = Wires.acquireStringBuilder();
                BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
                zonedDateTime.accept(ZonedDateTime.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn date(@NotNull Consumer<LocalDate> localDate) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 180) {
                StringBuilder sb = Wires.acquireStringBuilder();
                BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
                localDate.accept(LocalDate.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean hasNextSequenceItem() {
            return BinaryWire.this.bytes.remaining() > 0L;
        }

        @Override
        public WireIn uuid(@NotNull Consumer<UUID> uuid) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 160) {
                uuid.accept(new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong()));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public WireIn int64array(@Nullable LongArrayValues values, @NotNull Consumer<LongArrayValues> setter) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 141) {
                if (!(values instanceof BinaryLongArrayReference)) {
                    values = new BinaryLongArrayReference();
                    setter.accept(values);
                }
                Byteable b = (Byteable)values;
                long length = BinaryLongArrayReference.peakLength(BinaryWire.this.bytes, BinaryWire.this.bytes.position());
                b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.position(), length);
                BinaryWire.this.bytes.skip(length);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public WireIn int64(LongValue value, @NotNull Consumer<LongValue> setter) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 167) {
                this.cantRead(code);
            }
            if (!(value instanceof BinaryLongReference)) {
                value = new BinaryLongReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.position(), length);
            BinaryWire.this.bytes.skip(length);
            return BinaryWire.this;
        }

        @Override
        public WireIn int32(IntValue value, @NotNull Consumer<IntValue> setter) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 166) {
                this.cantRead(code);
            }
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 4L) {
                value = new IntBinaryReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.position(), length);
            BinaryWire.this.bytes.skip(length);
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WireIn sequence(@NotNull Consumer<ValueIn> reader) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 130) {
                this.cantRead(code);
            }
            int length = BinaryWire.this.bytes.readInt();
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.position() + (long)length;
            BinaryWire.this.bytes.limit(limit2);
            BinaryWire.this.bytes.limit(limit2);
            try {
                reader.accept(this);
            }
            finally {
                BinaryWire.this.bytes.limit(limit);
                BinaryWire.this.bytes.position(limit2);
            }
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(Function<WireIn, T> marshallableReader) {
            BinaryWire.this.consumeSpecial();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.position() + length;
                BinaryWire.this.bytes.limit(limit2);
                try {
                    T t = marshallableReader.apply(BinaryWire.this);
                    return t;
                }
                finally {
                    BinaryWire.this.bytes.limit(limit);
                    BinaryWire.this.bytes.position(limit2);
                }
            }
            return marshallableReader.apply(BinaryWire.this);
        }

        @Override
        @NotNull
        public WireIn type(@NotNull StringBuilder s) {
            int code = BinaryWire.this.readCode();
            if (code == 182) {
                BinaryWire.this.bytes.readUTF\u0394((Appendable)s);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            BinaryWire.this.consumeSpecial();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.position() + length;
                BinaryWire.this.bytes.limit(limit2);
                try {
                    object.readMarshallable(BinaryWire.this);
                }
                finally {
                    BinaryWire.this.bytes.limit(limit);
                    BinaryWire.this.bytes.position(limit2);
                }
            } else {
                object.readMarshallable(BinaryWire.this);
            }
            return BinaryWire.this;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        private long readTextAsLong() {
            BinaryWire.this.bytes.skip(-1L);
            String text = this.text();
            if (text == null) {
                throw new NullPointerException();
            }
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                return Math.round(Double.parseDouble(text));
            }
        }

        private double readTextAsDouble() {
            BinaryWire.this.bytes.skip(-1L);
            String text = this.text();
            if (text == null) {
                throw new NullPointerException();
            }
            return Double.parseDouble(text);
        }

        @Override
        public boolean bool() {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                return Boolean.valueOf(this.text());
            }
            switch (code) {
                case 177: {
                    return true;
                }
                case 176: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public byte int8() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 127L || value < -128L) {
                throw new IllegalStateException();
            }
            return (byte)value;
        }

        @Override
        public short int16() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 32767L || value < -32768L) {
                throw new IllegalStateException();
            }
            return (short)value;
        }

        @Override
        public int uint16() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 0x100000000L || value < 0L) {
                throw new IllegalStateException();
            }
            return (int)value;
        }

        private boolean isSmallInt(int code) {
            return (code & 0x80) == 0;
        }

        @Override
        public int int32() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalStateException();
            }
            return (int)value;
        }

        @Override
        public long int64() {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code >> 4 == 9) {
                return (long)BinaryWire.this.readFloat0(code);
            }
            return this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
        }

        @Override
        public double float64() {
            double value;
            int code = BinaryWire.this.readCode();
            double d = value = this.isText(code) ? (double)this.readTextAsLong() : BinaryWire.this.readFloat0(code);
            if (value > Double.MAX_VALUE || value < Double.MIN_VALUE) {
                throw new IllegalStateException();
            }
            return value;
        }

        @Override
        public float float32() {
            double value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            double d = value = this.isText(code) ? (double)this.readTextAsLong() : BinaryWire.this.readFloat0(code);
            if (value > 3.4028234663852886E38 || value < (double)1.4E-45f) {
                throw new IllegalStateException();
            }
            return (float)value;
        }

        private WireIn cantRead(int code) {
            throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
        }
    }

    class BinaryValueOut
    extends FixedBinaryValueOut {
        BinaryValueOut() {
        }

        @Override
        public WireOut int8(byte i8) {
            this.writeNumber(i8);
            return BinaryWire.this;
        }

        void writeNumber(long l) {
            if (l >= 0L && l <= 127L) {
                BinaryWire.this.bytes.writeUnsignedByte((int)l);
                return;
            }
            if (l >= 0L) {
                if (l <= 255L) {
                    super.uint8checked((short)l);
                    return;
                }
                if (l <= 65535L) {
                    super.uint16checked((int)l);
                    return;
                }
                if (l <= 0xFFFFFFFFL) {
                    super.uint32checked(l);
                    return;
                }
                if ((long)((float)l) == l) {
                    super.float32(l);
                    return;
                }
                super.int64(l);
                return;
            }
            if (l >= -128L && l <= 127L) {
                super.int8((byte)l);
                return;
            }
            if (l >= -32768L && l <= 32767L) {
                super.int16((short)l);
                return;
            }
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                super.int32((int)l);
                return;
            }
            if ((long)((float)l) == l) {
                super.float32(l);
                return;
            }
            super.int64(l);
        }

        void writeNumber(double l) {
            boolean canOnlyBeRepresentedAsFloatingPoint;
            boolean bl = canOnlyBeRepresentedAsFloatingPoint = (double)((long)l) != l;
            if (l >= 0.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                BinaryWire.this.bytes.writeUnsignedByte((int)l);
                return;
            }
            if (l >= 0.0) {
                if (l <= 255.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint8checked((short)l);
                    return;
                }
                if (l <= 65535.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint16checked((int)l);
                    return;
                }
                if ((double)((float)l) == l) {
                    super.float32((float)l);
                    return;
                }
                if (l <= 4.294967295E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint32checked((int)l);
                    return;
                }
                super.float64(l);
                return;
            }
            if (l >= -128.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int8((byte)l);
                return;
            }
            if (l >= -32768.0 && l <= 32767.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int16((short)l);
                return;
            }
            if ((double)((float)l) == l) {
                super.float32((float)l);
                return;
            }
            if (l >= -2.147483648E9 && l <= 2.147483647E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.uint32checked((int)l);
                return;
            }
            super.float64(l);
        }

        @Override
        public WireOut uint8checked(int u8) {
            this.writeNumber(u8);
            return BinaryWire.this;
        }

        @Override
        public WireOut int16(short i16) {
            this.writeNumber(i16);
            return BinaryWire.this;
        }

        @Override
        public WireOut uint16checked(int u16) {
            this.writeNumber(u16);
            return BinaryWire.this;
        }

        @Override
        public WireOut int32(int i32) {
            this.writeNumber(i32);
            return BinaryWire.this;
        }

        @Override
        public WireOut uint32checked(long u32) {
            this.writeNumber(u32);
            return BinaryWire.this;
        }

        @Override
        public WireOut int64(long i64) {
            this.writeNumber(i64);
            return BinaryWire.this;
        }

        @Override
        public WireOut float32(float f) {
            this.writeNumber(f);
            return BinaryWire.this;
        }

        @Override
        public WireOut float64(double d) {
            this.writeNumber(d);
            return BinaryWire.this;
        }
    }

    class FixedBinaryValueOut
    implements ValueOut {
        boolean nested = false;

        FixedBinaryValueOut() {
        }

        @Override
        public ValueOut leaf() {
            return this;
        }

        @Override
        public WireOut bool(Boolean flag) {
            BinaryWire.this.bytes.writeUnsignedByte(flag == null ? 187 : (flag != false ? 177 : 176));
            return BinaryWire.this;
        }

        @Override
        public WireOut text(CharSequence s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).append(s);
                } else {
                    BinaryWire.this.writeCode(184).writeUTF\u0394(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        public WireOut int8(byte i8) {
            BinaryWire.this.writeCode(164).writeByte(i8);
            return BinaryWire.this;
        }

        @Override
        public WireOut bytes(Bytes fromBytes) {
            this.writeLength(Maths.toInt32((long)(fromBytes.remaining() + 1L)));
            BinaryWire.this.writeCode(138);
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        public WireOut rawBytes(byte[] value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public ValueOut writeLength(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Invalid length " + length);
            }
            BinaryWire.this.writeCode(130);
            BinaryWire.this.bytes.writeUnsignedInt(length);
            return this;
        }

        @Override
        public WireOut bytes(byte[] fromBytes) {
            this.writeLength(Maths.toInt32((long)(fromBytes.length + 1)));
            BinaryWire.this.writeCode(138);
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        public WireOut uint8checked(int u8) {
            BinaryWire.this.writeCode(161).writeUnsignedByte(u8);
            return BinaryWire.this;
        }

        @Override
        public WireOut int16(short i16) {
            BinaryWire.this.writeCode(165).writeShort(i16);
            return BinaryWire.this;
        }

        @Override
        public WireOut uint16checked(int u16) {
            BinaryWire.this.writeCode(162).writeUnsignedShort(u16);
            return BinaryWire.this;
        }

        @Override
        public WireOut utf8(int codepoint) {
            BinaryWire.this.writeCode(162);
            BytesUtil.appendUTF(BinaryWire.this.bytes, (int)codepoint);
            return BinaryWire.this;
        }

        @Override
        public WireOut int32(int i32) {
            BinaryWire.this.writeCode(166).writeInt(i32);
            return BinaryWire.this;
        }

        @Override
        public WireOut uint32checked(long u32) {
            BinaryWire.this.writeCode(163).writeUnsignedInt(u32);
            return BinaryWire.this;
        }

        @Override
        public WireOut int64(long i64) {
            return this.fixedInt64(i64);
        }

        private WireOut fixedInt64(long i64) {
            BinaryWire.this.writeCode(167).writeLong(i64);
            return BinaryWire.this;
        }

        @Override
        public WireOut int64array(long capacity) {
            BinaryWire.this.writeCode(141);
            BinaryLongArrayReference.lazyWrite(BinaryWire.this.bytes, capacity);
            return BinaryWire.this;
        }

        @Override
        public WireOut float32(float f) {
            BinaryWire.this.writeCode(144).writeFloat(f);
            return BinaryWire.this;
        }

        @Override
        public WireOut float64(double d) {
            BinaryWire.this.writeCode(145).writeDouble(d);
            return BinaryWire.this;
        }

        @Override
        public WireOut time(LocalTime localTime) {
            BinaryWire.this.writeCode(178).writeUTF\u0394((CharSequence)localTime.toString());
            return BinaryWire.this;
        }

        @Override
        public WireOut zonedDateTime(ZonedDateTime zonedDateTime) {
            BinaryWire.this.writeCode(181).writeUTF\u0394((CharSequence)zonedDateTime.toString());
            return BinaryWire.this;
        }

        @Override
        public WireOut date(LocalDate localDate) {
            BinaryWire.this.writeCode(180).writeUTF\u0394((CharSequence)localDate.toString());
            return BinaryWire.this;
        }

        @Override
        public WireOut type(CharSequence typeName) {
            BinaryWire.this.writeCode(182).writeUTF\u0394(typeName);
            return BinaryWire.this;
        }

        @Override
        public WireOut uuid(UUID uuid) {
            BinaryWire.this.writeCode(160).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits());
            return BinaryWire.this;
        }

        @Override
        public WireOut int32forBinding(int value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.position() & 0x3FL);
            if (fromEndOfCacheLine < 5) {
                BinaryWire.this.addPadding(fromEndOfCacheLine - 1);
            }
            this.fixedInt64(value);
            return BinaryWire.this;
        }

        @Override
        public WireOut int64forBinding(long value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.position() & 0x3FL);
            if (fromEndOfCacheLine < 9) {
                BinaryWire.this.addPadding(fromEndOfCacheLine - 1);
            }
            this.fixedInt64(value);
            return BinaryWire.this;
        }

        @Override
        public WireOut sequence(Consumer<ValueOut> writer) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.position();
            BinaryWire.this.bytes.writeInt(0);
            writer.accept(this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.position() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        public WireOut marshallable(WriteMarshallable object) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.position();
            BinaryWire.this.bytes.writeInt(0);
            object.writeMarshallable(BinaryWire.this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.position() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        public WireOut map(Map map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public WireOut wireOut() {
            return BinaryWire.this;
        }
    }
}

