/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.util;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.ByteableLongArrayValues;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public class WireUtil {
    public static ThreadLocal<ByteableLongArrayValues> newLongArrayValuesPool(@NotNull Class<? extends Wire> wireType) {
        if (TextWire.class.isAssignableFrom(wireType)) {
            return ThreadLocal.withInitial(TextLongArrayReference::new);
        }
        if (BinaryWire.class.isAssignableFrom(wireType)) {
            return ThreadLocal.withInitial(BinaryLongArrayReference::new);
        }
        throw new IllegalStateException("todo, unsupported type=" + wireType);
    }

    public static Function<Bytes, Wire> byteToWireFor(@NotNull Class<? extends Wire> wireType) {
        if (TextWire.class.isAssignableFrom(wireType)) {
            return TextWire::new;
        }
        if (BinaryWire.class.isAssignableFrom(wireType)) {
            return BinaryWire::new;
        }
        if (RawWire.class.isAssignableFrom(wireType)) {
            return RawWire::new;
        }
        throw new UnsupportedOperationException("todo (byteToWireFor)");
    }

    public static Wire createWire(@NotNull Class<? extends Wire> wireType, @NotNull Bytes bytes) {
        return WireUtil.byteToWireFor(wireType).apply(bytes);
    }
}

