/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.IntValue;

public class IntBinaryReference
implements IntValue,
Byteable {
    private BytesStore bytes;
    private long offset;

    public void bytesStore(BytesStore bytes, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.bytes = bytes;
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    public long offset() {
        return this.offset;
    }

    public long maxSize() {
        return 4L;
    }

    public String toString() {
        return "value: " + this.getValue();
    }

    public int getValue() {
        return this.bytes.readInt(this.offset);
    }

    public void setValue(int value) {
        this.bytes.writeInt(this.offset, value);
    }

    public int getVolatileValue() {
        return this.bytes.readVolatileInt(this.offset);
    }

    public void setOrderedValue(int value) {
        this.bytes.writeOrderedInt(this.offset, value);
    }

    public int addValue(int delta) {
        return this.bytes.addAndGetInt(this.offset, delta);
    }

    public int addAtomicValue(int delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(int expected, int value) {
        return this.bytes.compareAndSwapLong(this.offset, (long)expected, (long)value);
    }
}

