/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.RawWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public enum WireType implements Function<Bytes, Wire>
{
    TEXT{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new TextWire(bytes);
        }
    }
    ,
    BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes);
        }
    }
    ,
    FIELDLESS_BINARY{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new BinaryWire(bytes, false, false, true);
        }
    }
    ,
    RAW{

        @Override
        @NotNull
        public Wire apply(Bytes bytes) {
            return new RawWire(bytes);
        }
    }
    ,
    READ_ANY{

        @Override
        public Wire apply(@NotNull Bytes bytes) {
            byte code = bytes.readByte(0L);
            if (code >= 32 && code < 127) {
                return (Wire)TEXT.apply(bytes);
            }
            if (BinaryWireCode.isFieldCode(code)) {
                return (Wire)FIELDLESS_BINARY.apply(bytes);
            }
            return (Wire)BINARY.apply(bytes);
        }
    };

}

