/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryLongReference;
import net.openhft.chronicle.wire.ByteableLongArrayValues;
import org.jetbrains.annotations.NotNull;

public class BinaryLongArrayReference
implements ByteableLongArrayValues {
    private static final long VALUES = 8L;
    private BytesStore bytes;
    private long offset;
    private long length = 8L;

    public static void write(@NotNull Bytes bytes, long capacity) {
        bytes.writeLong(capacity);
        long start = bytes.writePosition() + 8L;
        bytes.zeroOut(start, start + (capacity << 3));
        bytes.writeSkip(capacity << 3);
    }

    public static void lazyWrite(@NotNull Bytes bytes, long capacity) {
        bytes.writeLong(capacity);
        bytes.writeSkip(capacity << 3);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) {
        long capacity = bytes.readLong(offset);
        assert (capacity > 0L) : "capacity too small";
        return (capacity << 3) + 8L;
    }

    public long getCapacity() {
        return this.length - 8L >>> 3;
    }

    public long getValueAt(long index) {
        return this.bytes.readLong(8L + this.offset + (index << 3));
    }

    public void setValueAt(long index, long value) {
        this.bytes.writeLong(8L + this.offset + (index << 3), value);
    }

    public long getVolatileValueAt(long index) {
        return this.bytes.readVolatileLong(8L + this.offset + (index << 3));
    }

    public void bindValueAt(int index, @NotNull LongValue value) {
        ((BinaryLongReference)value).bytesStore(this.bytes, 8L + this.offset + (long)(index << 3), 8L);
    }

    public void setOrderedValueAt(long index, long value) {
        this.bytes.writeOrderedLong(8L + this.offset + (index << 3), value);
    }

    public boolean compareAndSet(long index, long expected, long value) {
        return this.bytes.compareAndSwapLong(8L + this.offset + (index << 3), expected, value);
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != BinaryLongArrayReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + BinaryLongArrayReference.peakLength(bytes, offset));
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        return "value: " + this.getValueAt(0L) + " ...";
    }
}

