/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.wire.ByteableLongArrayValues;
import org.jetbrains.annotations.NotNull;

public class TextLongArrayReference
implements ByteableLongArrayValues {
    static final byte[] SECTION1 = "{ capacity: ".getBytes();
    static final byte[] SECTION2 = ", values: [ ".getBytes();
    static final byte[] SECTION3 = " ] }\n".getBytes();
    static final byte[] ZERO = "00000000000000000000".getBytes();
    static final byte[] SEP = ", ".getBytes();
    private static final int DIGITS = ZERO.length;
    private static final int CAPACITY = SECTION1.length;
    private static final int VALUES = CAPACITY + DIGITS + SECTION2.length;
    private static final int VALUE_SIZE = DIGITS + SEP.length;
    private BytesStore bytes;
    private long offset;
    private long length = VALUES;

    public static void write(@NotNull Bytes bytes, long capacity) {
        bytes.write(SECTION1);
        bytes.append(capacity, 20);
        bytes.write(SECTION2);
        for (long i = 0L; i < capacity; ++i) {
            if (i > 0L) {
                bytes.append((CharSequence)", ");
            }
            bytes.write(ZERO);
        }
        bytes.write(SECTION3);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) {
        return bytes.parseLong(offset + (long)CAPACITY) * (long)VALUE_SIZE + (long)VALUES + (long)SECTION3.length - (long)SEP.length;
    }

    public long getCapacity() {
        return (this.length - (long)VALUES) / (long)VALUE_SIZE;
    }

    public long getValueAt(long index) {
        return this.bytes.parseLong((long)VALUES + this.offset + index * (long)VALUE_SIZE);
    }

    public void setValueAt(long index, long value) {
        this.bytes.append((long)VALUES + this.offset + index * (long)VALUE_SIZE, value, DIGITS);
    }

    public long getVolatileValueAt(long index) {
        OS.memory().loadFence();
        return this.getValueAt(index);
    }

    public void setOrderedValueAt(long index, long value) {
        this.setValueAt(index, value);
        OS.memory().storeFence();
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != TextLongArrayReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + TextLongArrayReference.peakLength(bytes, offset));
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "LongArrayTextReference{bytes=null, offset=" + this.offset + ", length=" + this.length + '}';
        }
        return "value: " + this.getValueAt(0L) + " ...";
    }
}

