/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.websocket.jetty;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.websocket.jetty.JettyDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketAdapter<T>
extends WebSocketAdapter
implements MarshallableOut {
    private static final Logger IN = LoggerFactory.getLogger((String)(JettyWebSocketAdapter.class.getName() + ".IN"));
    private static final Logger OUT = LoggerFactory.getLogger((String)(JettyWebSocketAdapter.class.getName() + ".OUT"));
    final ThreadLocal<Wire> inWireTL = ThreadLocal.withInitial(() -> new JSONWire((Bytes)Bytes.allocateElasticDirect()));
    final ThreadLocal<JettyDocumentContext> writingDocumentTL = ThreadLocal.withInitial(() -> new JettyDocumentContext(0, this::sendWireContents));
    private final T wrapper;
    private final BiConsumer<WireIn, T> channel;
    private final int sourceId;

    public JettyWebSocketAdapter(Function<MarshallableOut, T> outWrapper, BiConsumer<WireIn, T> channel) {
        this(outWrapper, channel, 0);
    }

    public JettyWebSocketAdapter(Function<MarshallableOut, T> outWrapper, BiConsumer<WireIn, T> channel, int sourceId) {
        this.sourceId = sourceId;
        this.channel = channel;
        this.wrapper = outWrapper.apply(this);
    }

    public boolean recordHistory() {
        return this.sourceId != 0;
    }

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
    }

    public Wire getInWire() {
        Wire wire = this.inWireTL.get();
        wire.clear();
        return wire;
    }

    public void onWebSocketText(String message) {
        if (IN.isDebugEnabled()) {
            IN.debug("message in - " + message);
        }
        Wire wire = this.getInWire();
        wire.bytes().append8bit(message);
        this.channel.accept((WireIn)wire, (WireIn)this.wrapper);
    }

    public RemoteEndpoint getRemote() throws WebSocketException {
        RemoteEndpoint remote = super.getRemote();
        if (remote == null) {
            throw new IORuntimeException("Not connected");
        }
        return remote;
    }

    public DocumentContext writingDocument(boolean metaData) {
        assert (!metaData);
        JettyDocumentContext context = this.writingDocumentTL.get();
        context.reset();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWireContents(Wire wire) {
        String strOut = wire.bytes().toString();
        try {
            RemoteEndpoint remote;
            RemoteEndpoint remoteEndpoint = remote = this.getRemote();
            synchronized (remoteEndpoint) {
                remote.sendString(strOut);
            }
            if (OUT.isDebugEnabled()) {
                OUT.debug("message out - " + strOut);
            }
        }
        catch (IOException | WebSocketException e) {
            throw new IORuntimeException(e);
        }
    }
}

