/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.websocket.jetty;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.servlet.Servlet;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.websocket.jetty.JettyServiceFactory;
import net.openhft.chronicle.websocket.jetty.JettyServletFactory;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.WireIn;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class JettyWebSocketServer {
    private final Server server = new Server();
    private final ServletContextHandler context;

    public JettyWebSocketServer(String host, int port) {
        ServerConnector connector = new ServerConnector(this.server);
        if (host != null) {
            connector.setHost(host);
        }
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        this.context = new ServletContextHandler(1);
        this.context.setContextPath("/");
        this.server.setHandler((Handler)this.context);
    }

    public JettyWebSocketServer(int port) {
        this(null, port);
    }

    public <T> void addServlet(String path, Function<MarshallableOut, T> outWrapper, BiConsumer<WireIn, T> channel) {
        this.addServlet(path, (Servlet)new JettyServletFactory<T>(outWrapper, channel));
    }

    public <S, R> void addService(String path, Class<R> responseClass, Function<R, S> serviceFactory) {
        this.addServlet(path, (Servlet)new JettyServiceFactory<R, S>(responseClass, serviceFactory));
    }

    private void addServlet(String path, Servlet servlet) {
        ServletHolder holderEvents = new ServletHolder(path, servlet);
        this.context.addServlet(holderEvents, path);
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public void close() throws IOException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

