/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.websocket.jetty;

import java.io.IOException;
import java.util.function.Function;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.websocket.jetty.JettyDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.Wire;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServiceAdapter<R, S>
extends WebSocketAdapter
implements MarshallableIn,
MarshallableOut {
    private static final Logger IN = LoggerFactory.getLogger((String)(JettyWebSocketServiceAdapter.class.getName() + ".IN"));
    private static final Logger OUT = LoggerFactory.getLogger((String)(JettyWebSocketServiceAdapter.class.getName() + ".OUT"));
    final ThreadLocal<JettyDocumentContext> readingDocumentTL = ThreadLocal.withInitial(() -> new JettyDocumentContext(0, w -> {}));
    final ThreadLocal<JettyDocumentContext> writingDocumentTL = ThreadLocal.withInitial(() -> new JettyDocumentContext(0, this::sendWireContents));
    private final MethodReader reader;

    public JettyWebSocketServiceAdapter(Class<R> responseClass, Function<R, S> serviceFactory) {
        Object writer = this.methodWriter(responseClass, new Class[0]);
        S service = serviceFactory.apply(writer);
        this.reader = this.methodReader(new Object[]{service});
    }

    public boolean recordHistory() {
        return false;
    }

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
    }

    public Wire getInWire() {
        Wire wire = this.readingDocumentTL.get().wire();
        wire.clear();
        return wire;
    }

    public void onWebSocketText(String message) {
        if (IN.isDebugEnabled()) {
            IN.debug("message in - " + message);
        }
        Wire wire = this.getInWire();
        wire.bytes().append8bit(message);
        while (this.reader.readOne()) {
        }
    }

    public RemoteEndpoint getRemote() throws WebSocketException {
        RemoteEndpoint remote = super.getRemote();
        if (remote == null) {
            throw new IORuntimeException("Not connected");
        }
        return remote;
    }

    public DocumentContext readingDocument() {
        return this.readingDocumentTL.get();
    }

    public DocumentContext writingDocument() {
        JettyDocumentContext context = this.writingDocumentTL.get();
        context.reset();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWireContents(Wire wire) {
        String strOut = wire.bytes().toString();
        try {
            RemoteEndpoint remote;
            RemoteEndpoint remoteEndpoint = remote = this.getRemote();
            synchronized (remoteEndpoint) {
                remote.sendString(strOut);
            }
            if (OUT.isDebugEnabled()) {
                OUT.debug("message out - " + strOut);
            }
        }
        catch (IOException | WebSocketException e) {
            throw new IORuntimeException(e);
        }
    }
}

