/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.websocket.jetty;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.websocket.jetty.JettyWebSocketAdapter;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.WireIn;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketClient
implements MarshallableOut,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketClient.class);
    private final WebSocketClient client;
    private final JettyWebSocketAdapter<MarshallableOut> adapter;
    private final boolean recordHistory;

    public JettyWebSocketClient(String uriString, BiConsumer<WireIn, MarshallableOut> parser) throws IOException {
        this(uriString, parser, false);
    }

    public JettyWebSocketClient(String uriString, BiConsumer<WireIn, MarshallableOut> parser, boolean recordHistory) throws IOException {
        this.recordHistory = recordHistory;
        URI uri = URI.create(uriString);
        this.client = new WebSocketClient();
        try {
            this.client.start();
            this.adapter = new JettyWebSocketAdapter<MarshallableOut>(out -> out, parser);
            Future fut = this.client.connect(this.adapter, uri);
            Session session = (Session)fut.get();
            this.adapter.onWebSocketConnect(session);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public DocumentContext writingDocument() {
        return this.adapter.writingDocument();
    }

    public boolean recordHistory() {
        return this.recordHistory;
    }

    public void close() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            LOGGER.info("Error on close of " + this.client, (Throwable)e);
        }
    }
}

