/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.ObjectHeapMemberGenerator;
import net.openhft.chronicle.values.ScalarFieldModel;
import net.openhft.chronicle.values.ValueBuilder;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.values.Values;

class ValueFieldModel
extends ScalarFieldModel {
    private final NativeMemberGenerator nativeGenerator = new NativeMemberGenerator();
    private ValueModel valueModel;

    ValueFieldModel() {
    }

    private ValueModel valueModel() {
        if (this.valueModel == null) {
            this.valueModel = ValueModel.acquire(this.type);
        }
        return this.valueModel;
    }

    @Override
    int sizeInBits() {
        return this.valueModel().sizeInBytes() * 8;
    }

    @Override
    int offsetAlignmentInBytes() {
        if (this.offsetAlignment == -1) {
            return this.valueModel().recommendedOffsetAlignment();
        }
        return Math.max(1, this.offsetAlignment);
    }

    @Override
    NativeMemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new ObjectHeapMemberGenerator(this){
            FieldSpec usingValue;

            @Override
            void generateFields(ValueBuilder valueBuilder) {
                this.field = FieldSpec.builder(ValueFieldModel.this.valueModel().heapClass(), (String)ValueFieldModel.this.fieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{ValueFieldModel.this.valueModel().heapClass()}).build();
                valueBuilder.typeBuilder.addField(this.field);
            }

            @Override
            void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
                this.field = FieldSpec.builder((TypeName)ArrayTypeName.of(ValueFieldModel.this.valueModel().heapClass()), (String)ValueFieldModel.this.fieldName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T[$L]", new Object[]{ValueFieldModel.this.valueModel().heapClass(), arrayFieldModel.array.length()}).build();
                valueBuilder.typeBuilder.addField(this.field);
                this.usingValue = FieldSpec.builder(ValueFieldModel.this.valueModel().heapClass(), (String)(ValueFieldModel.this.fieldName() + "Value"), (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{ValueFieldModel.this.valueModel().heapClass()}).build();
                valueBuilder.typeBuilder.addField(this.usingValue);
                MethodSpec.Builder constructor = valueBuilder.defaultConstructorBuilder();
                constructor.beginControlFlow("for (int index = 0; index < $L; index++)", new Object[]{arrayFieldModel.array.length()});
                constructor.addStatement("$N[index] = new $T()", new Object[]{ValueFieldModel.this.fieldName(), ValueFieldModel.this.valueModel().heapClass()});
                constructor.endControlFlow();
            }

            @Override
            void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("(($T) $N).copyFrom($N[index])", new Object[]{Copyable.class, ValueFieldModel.this.usingName(), this.field});
                if (arrayFieldModel.getUsing.getReturnType() != Void.TYPE) {
                    methodBuilder.addStatement("return $N", new Object[]{ValueFieldModel.this.usingName()});
                }
            }

            @Override
            public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.copyFrom($N)", new Object[]{this.field, ValueFieldModel.this.varName()});
            }

            @Override
            public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].copyFrom($N)", new Object[]{this.field, ValueFieldModel.this.varName()});
            }

            @Override
            public void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.copyFrom($N)", new Object[]{this.field, ValueFieldModel.this.varName()});
                methodBuilder.addStatement("$N.storeFence()", new Object[]{valueBuilder.unsafe()});
            }

            @Override
            public void generateArrayElementSetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].copyFrom($N)", new Object[]{this.field, ValueFieldModel.this.varName()});
                methodBuilder.addStatement("$N.storeFence()", new Object[]{valueBuilder.unsafe()});
            }

            @Override
            public void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.generateSetVolatile(valueBuilder, methodBuilder);
            }

            @Override
            public void generateArrayElementSetOrdered(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.generateArrayElementSetVolatile(arrayFieldModel, valueBuilder, methodBuilder);
            }

            @Override
            public void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                throw new UnsupportedOperationException("compareAndSwap() is not supported by value field " + ValueFieldModel.this.name);
            }

            @Override
            public void generateArrayElementCompareAndSwap(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                throw new UnsupportedOperationException("compareAndSwap() is not supported by value field " + ValueFieldModel.this.name);
            }

            @Override
            public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.copyFrom(from.$N())", new Object[]{this.field, this.fieldModel.getOrGetVolatile().getName()});
            }

            @Override
            void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                if (arrayFieldModel.getUsing != null) {
                    methodBuilder.addStatement("other.$N(index, this.$N)", new Object[]{arrayFieldModel.getUsing.getName(), this.usingValue});
                    methodBuilder.addCode("if (!$T.equals($N[index], this.$N)) return false;\n", new Object[]{Objects.class, this.field, this.usingValue});
                } else {
                    methodBuilder.addCode("if (!$T.equals($N[index], other.$N(index))) return false;\n", new Object[]{Objects.class, this.field, arrayFieldModel.getOrGetVolatile().getName()});
                }
            }

            @Override
            public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                if (arrayFieldModel.getUsing != null) {
                    methodBuilder.addStatement("from.$N(index, this.$N[index])", new Object[]{arrayFieldModel.getUsing.getName(), this.field});
                } else {
                    methodBuilder.addStatement("this.$N[index].copyFrom(from.$N(index))", new Object[]{this.field, arrayFieldModel.getOrGetVolatile().getName()});
                }
            }

            @Override
            void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.writeMarshallable(bytes)", new Object[]{ValueFieldModel.this.fieldName()});
            }

            @Override
            void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].writeMarshallable(bytes)", new Object[]{ValueFieldModel.this.fieldName()});
            }

            @Override
            void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N.readMarshallable(bytes)", new Object[]{ValueFieldModel.this.fieldName()});
            }

            @Override
            void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index].readMarshallable(bytes)", new Object[]{ValueFieldModel.this.fieldName()});
            }

            @Override
            String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                return this.field.name + ".hashCode()";
            }

            @Override
            String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                return this.field.name + "[index].hashCode()";
            }
        };
    }

    final class NativeMemberGenerator
    extends MemberGenerator {
        FieldSpec cachedValue;
        FieldSpec otherCachedValue;
        private Class<?> nativeType;

        NativeMemberGenerator() {
            super(ValueFieldModel.this);
        }

        @Override
        public void generateFields(ValueBuilder valueBuilder) {
            this.nativeType = Values.nativeClassFor(ValueFieldModel.this.type);
            this.cachedValue = FieldSpec.builder(this.nativeType, (String)(ValueFieldModel.this.name + "CachedValue"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{this.nativeType}).build();
            valueBuilder.typeBuilder.addField(this.cachedValue);
            this.otherCachedValue = FieldSpec.builder(this.nativeType, (String)(ValueFieldModel.this.name + "OtherCachedValue"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{this.nativeType}).build();
            valueBuilder.typeBuilder.addField(this.otherCachedValue);
        }

        @Override
        public void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            this.generateFields(valueBuilder);
        }

        private void initCachedValue(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$T $N = this.$N", new Object[]{this.nativeType, this.cachedValue, this.cachedValue});
            int byteOffset = ValueFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("$N.bytesStore(bs, offset + $L, $L)", new Object[]{this.cachedValue, byteOffset, ValueFieldModel.this.valueModel().sizeInBytes()});
        }

        @Override
        public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("return $N", new Object[]{this.cachedValue});
        }

        @Override
        public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("return $N", new Object[]{this.cachedValue});
        }

        private void initArrayElementCachedValue(ArrayFieldModel arrayField, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$T $N = this.$N", new Object[]{this.nativeType, this.cachedValue, this.cachedValue});
            int arrayByteOffset = arrayField.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayField, methodBuilder);
            methodBuilder.addStatement("$N.bytesStore(bs, offset + $L + elementOffset, $L)", new Object[]{this.cachedValue, arrayByteOffset, ValueFieldModel.this.valueModel().sizeInBytes()});
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", new Object[]{ValueFieldModel.this.varName(), this.nativeType});
            int byteOffset = ValueFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("(($T) $N).bytesStore(bs, offset + $L, $L)", new Object[]{this.nativeType, ValueFieldModel.this.varName(), byteOffset, ValueFieldModel.this.valueModel().sizeInBytes()});
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("(($T) $N).copyFrom($N)", new Object[]{Copyable.class, ValueFieldModel.this.varName(), this.cachedValue});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return $N", new Object[]{ValueFieldModel.this.varName()});
        }

        @Override
        public void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", new Object[]{ValueFieldModel.this.usingName(), this.nativeType});
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("(($T) $N).bytesStore(bs, offset + $L + elementOffset, $L)", new Object[]{this.nativeType, ValueFieldModel.this.usingName(), arrayByteOffset, ValueFieldModel.this.valueModel().sizeInBytes()});
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("(($T) $N).copyFrom($N)", new Object[]{Copyable.class, ValueFieldModel.this.usingName(), this.cachedValue});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return $N", new Object[]{ValueFieldModel.this.usingName()});
        }

        @Override
        public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", new Object[]{ValueFieldModel.this.varName(), this.nativeType});
            int byteOffset = ValueFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("bs.write(offset + $L, (($T) $N).bytesStore(), (($T) $N).offset(), $L)", new Object[]{byteOffset, this.nativeType, ValueFieldModel.this.varName(), this.nativeType, ValueFieldModel.this.varName(), ValueFieldModel.this.valueModel().sizeInBytes()});
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.copyFrom($N)", new Object[]{this.cachedValue, ValueFieldModel.this.varName()});
            methodBuilder.endControlFlow();
        }

        @Override
        public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("if ($N instanceof $T)", new Object[]{ValueFieldModel.this.varName(), this.nativeType});
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            methodBuilder.addStatement("bs.write(offset + $L + elementOffset, (($T) $N).bytesStore(), (($T) $N).offset(), $L)", new Object[]{arrayByteOffset, this.nativeType, ValueFieldModel.this.varName(), this.nativeType, ValueFieldModel.this.varName(), ValueFieldModel.this.valueModel().sizeInBytes()});
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.copyFrom($N)", new Object[]{this.cachedValue, ValueFieldModel.this.varName()});
            methodBuilder.endControlFlow();
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            if (ValueFieldModel.this.getUsing != null) {
                methodBuilder.addStatement("from.$N($N)", new Object[]{ValueFieldModel.this.getUsing.getName(), this.cachedValue});
            } else {
                methodBuilder.addStatement("$N.copyFrom(from.$N())", new Object[]{this.cachedValue, ValueFieldModel.this.get.getName()});
            }
        }

        @Override
        public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                methodBuilder.addStatement("from.$N(index, $N)", new Object[]{getUsing.getName(), this.cachedValue});
            } else {
                methodBuilder.addStatement("$N.copyFrom(from.$N(index))", new Object[]{this.cachedValue, arrayFieldModel.get.getName()});
            }
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.writeMarshallable(bytes)", new Object[]{this.cachedValue});
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.writeMarshallable(bytes)", new Object[]{this.cachedValue});
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.readMarshallable(bytes)", new Object[]{this.cachedValue});
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N.readMarshallable(bytes)", new Object[]{this.cachedValue});
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            methodBuilder.addCode("if (!$N.equals(other.$N())) return false;\n", new Object[]{this.cachedValue, ValueFieldModel.this.get.getName()});
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                methodBuilder.addStatement("$T $N = this.$N", new Object[]{ValueFieldModel.this.type, this.otherCachedValue, this.otherCachedValue});
                methodBuilder.addStatement("other.$N(index, $N)", new Object[]{getUsing.getName(), this.otherCachedValue});
                methodBuilder.addCode("if (!$N.equals($N)) return false;\n", new Object[]{this.cachedValue, this.otherCachedValue});
            } else {
                methodBuilder.addCode("if (!$N.equals(other.$N(index))) return false;\n", new Object[]{this.cachedValue, arrayFieldModel.get.getName()});
            }
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            return this.cachedValue.name + ".hashCode()";
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            return this.cachedValue.name + ".hashCode()";
        }

        @Override
        void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedValue(valueBuilder, methodBuilder);
            this.genToString(methodBuilder, this.cachedValue.name);
        }

        @Override
        void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedValue(arrayFieldModel, valueBuilder, methodBuilder);
            this.genArrayElementToString(methodBuilder, this.cachedValue.name);
        }
    }
}

