/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.values.Align;
import net.openhft.chronicle.values.Array;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.CharSequences;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.Enums;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.Group;
import net.openhft.chronicle.values.MaxUtf8Length;
import net.openhft.chronicle.values.NotNull;
import net.openhft.chronicle.values.Range;
import net.openhft.chronicle.values.SimpleURIClassObject;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.values.Values;

class MyJavaFileManager
implements JavaFileManager {
    private static final Map<String, Set<JavaFileObject>> dependencyFileObjects = new HashMap<String, Set<JavaFileObject>>();
    private final Map<String, Set<JavaFileObject>> fileObjects;
    private final StandardJavaFileManager fileManager;
    private final Map<String, ByteArrayOutputStream> buffers = new LinkedHashMap<String, ByteArrayOutputStream>();

    MyJavaFileManager(Class valueType, StandardJavaFileManager fileManager) {
        this.fileObjects = new HashMap<String, Set<JavaFileObject>>(dependencyFileObjects);
        this.fileObjects.replaceAll((p, objects) -> new HashSet(objects));
        MyJavaFileManager.addFileObjects(this.fileObjects, valueType);
        this.fileManager = fileManager;
    }

    private static void addFileObjects(Map<String, Set<JavaFileObject>> fileObjects, Class<?> c) {
        Type[] interfaces;
        fileObjects.compute(c.getPackage().getName(), (p, objects) -> {
            if (objects == null) {
                objects = new HashSet<JavaFileObject>();
            }
            objects.add(MyJavaFileManager.classFileObject(c));
            return objects;
        });
        for (Type superInterface : interfaces = c.getGenericInterfaces()) {
            Class rawInterface = ValueModel.rawInterface(superInterface);
            MyJavaFileManager.addFileObjects(fileObjects, rawInterface);
        }
    }

    private static JavaFileObject classFileObject(Class<?> c) {
        try {
            String className = c.getName();
            int lastDotIndex = className.lastIndexOf(46);
            URI uri = c.getResource(className.substring(lastDotIndex + 1) + ".class").toURI();
            return new SimpleURIClassObject(uri, c);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.fileManager.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> delegateFileObjects = this.fileManager.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> packageFileObjects = (ArrayList<JavaFileObject>)((Object)this.fileObjects.get(packageName));
        if (packageFileObjects != null) {
            packageFileObjects = new ArrayList<JavaFileObject>(packageFileObjects);
            delegateFileObjects.forEach(packageFileObjects::add);
            return packageFileObjects;
        }
        return delegateFileObjects;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof SimpleURIClassObject) {
            return ((SimpleURIClassObject)file).c.getName();
        }
        return this.fileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.fileManager.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.fileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location == StandardLocation.CLASS_OUTPUT && this.buffers.containsKey(className) && kind == JavaFileObject.Kind.CLASS) {
            final byte[] bytes = this.buffers.get(className).toByteArray();
            return new SimpleJavaFileObject(URI.create(className), kind){

                @Override
                @org.jetbrains.annotations.NotNull
                public InputStream openInputStream() {
                    return new ByteArrayInputStream(bytes);
                }
            };
        }
        return this.fileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return new SimpleJavaFileObject(URI.create(className), kind){

            @Override
            @org.jetbrains.annotations.NotNull
            public OutputStream openOutputStream() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MyJavaFileManager.this.buffers.put(className, baos);
                return baos;
            }
        };
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.fileManager.close();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fileManager.isSupportedOption(option);
    }

    @org.jetbrains.annotations.NotNull
    public Map<String, byte[]> getAllBuffers() {
        LinkedHashMap<String, byte[]> ret = new LinkedHashMap<String, byte[]>(this.buffers.size() * 2);
        for (Map.Entry<String, ByteArrayOutputStream> entry : this.buffers.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().toByteArray());
        }
        return ret;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) {
        try {
            Method getLocationForModule = Jvm.getMethod(JavaFileManager.class, (String)"getLocationForModule", (Class[])new Class[]{JavaFileManager.Location.class, String.class});
            return (JavaFileManager.Location)getLocationForModule.invoke((Object)this.fileManager, location, moduleName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) {
        try {
            Method getLocationForModule = Jvm.getMethod(JavaFileManager.class, (String)"getLocationForModule", (Class[])new Class[]{JavaFileManager.Location.class, JavaFileObject.class});
            return (JavaFileManager.Location)getLocationForModule.invoke((Object)this.fileManager, location, fo);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) {
        try {
            Method getServiceLoader = Jvm.getMethod(JavaFileManager.class, (String)"getServiceLoader", (Class[])new Class[]{JavaFileManager.Location.class, Class.class});
            return (ServiceLoader)getServiceLoader.invoke((Object)this.fileManager, location, service);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) {
        try {
            Method inferModuleName = Jvm.getMethod(JavaFileManager.class, (String)"inferModuleName", (Class[])new Class[]{JavaFileManager.Location.class});
            return (String)inferModuleName.invoke((Object)this.fileManager, location);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) {
        try {
            Method listLocationsForModules = Jvm.getMethod(JavaFileManager.class, (String)"listLocationsForModules", (Class[])new Class[]{JavaFileManager.Location.class});
            return (Iterable)listLocationsForModules.invoke((Object)this.fileManager, location);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) {
        try {
            Method contains = Jvm.getMethod(JavaFileManager.class, (String)"contains", (Class[])new Class[]{JavaFileManager.Location.class, JavaFileObject.class});
            return (Boolean)contains.invoke((Object)this.fileManager, location, fo);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        Arrays.asList(Enums.class, CharSequences.class, ValueModel.class, Values.class, FieldModel.class, ArrayFieldModel.class, Copyable.class, Align.class, Array.class, Group.class, MaxUtf8Length.class, NotNull.class, Range.class, Bytes.class, BytesStore.class, BytesUtil.class, Byteable.class, BytesMarshallable.class, IORuntimeException.class).forEach(c -> MyJavaFileManager.addFileObjects(dependencyFileObjects, c));
    }
}

