/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.PrimitiveHeapMemberGenerator;
import net.openhft.chronicle.values.ValueBuilder;
import sun.misc.Unsafe;

class NumberHeapMemberGenerator
extends PrimitiveHeapMemberGenerator {
    NumberHeapMemberGenerator(FieldModel fieldModel) {
        super(fieldModel);
    }

    private String getAndAdd() {
        return "getAndAdd" + this.capType;
    }

    @Override
    public void generateAdd(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        if (this.fieldModel.type != Byte.TYPE && this.fieldModel.type != Character.TYPE && this.fieldModel.type != Short.TYPE) {
            methodBuilder.addStatement("$T $N = " + this.wrap("$N") + " + addition", new Object[]{this.fieldModel.type, this.fieldModel.varName(), this.field});
        } else {
            methodBuilder.addStatement("$T $N = ($T) (" + this.wrap("$N") + " + addition)", new Object[]{this.fieldModel.type, this.fieldModel.varName(), this.fieldModel.type, this.field});
        }
        methodBuilder.addStatement("$N = " + this.unwrap("$N"), new Object[]{this.field, this.fieldModel.varName()});
        methodBuilder.addStatement("return $N", new Object[]{this.fieldModel.varName()});
    }

    @Override
    public void generateArrayElementAdd(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("$T $N = " + this.wrap("$N[index]") + " + addition", new Object[]{this.fieldModel.type, this.fieldModel.varName(), this.field});
        methodBuilder.addStatement("$N[index] = " + this.unwrap("$N"), new Object[]{this.field, this.fieldModel.varName()});
        methodBuilder.addStatement("return $N", new Object[]{this.fieldModel.varName()});
    }

    @Override
    public void generateAddAtomic(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("return " + this.wrap("$N.$N(this, $N, addition) + addition"), new Object[]{valueBuilder.unsafe(), this.getAndAdd(), this.fieldOffset(valueBuilder)});
    }

    @Override
    public void generateArrayElementAddAtomic(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        methodBuilder.addStatement("return " + this.wrap("$N.$N($N, (long) $T.$N + (index * (long) $T.$N), addition) + addition"), new Object[]{valueBuilder.unsafe(), this.getAndAdd(), this.field, Unsafe.class, this.arrayBase(), Unsafe.class, this.arrayScale()});
    }
}

