/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import java.util.Objects;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.HeapMemberGenerator;
import net.openhft.chronicle.values.ValueBuilder;
import sun.misc.Unsafe;

class ObjectHeapMemberGenerator
extends HeapMemberGenerator {
    ObjectHeapMemberGenerator(FieldModel fieldModel) {
        super(fieldModel);
    }

    @Override
    String putVolatile() {
        return "putVolatileObject";
    }

    @Override
    String putOrdered() {
        return "putOrderedObject";
    }

    @Override
    String compareAndSwap() {
        return "compareAndSwapObject";
    }

    @Override
    String arrayBase() {
        return "ARRAY_OBJECT_BASE_OFFSET";
    }

    @Override
    String arrayScale() {
        return "ARRAY_OBJECT_INDEX_SCALE";
    }

    @Override
    String wrap(String rawStoredValue) {
        return rawStoredValue;
    }

    @Override
    String unwrap(String inputValue) {
        return inputValue;
    }

    @Override
    public void generateGetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("return ($T) $N.getObjectVolatile(this, $N)", new Object[]{this.fieldModel.type, valueBuilder.unsafe(), this.fieldOffset(valueBuilder)});
    }

    @Override
    public void generateArrayElementGetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        methodBuilder.addStatement("return ($T) $N.getObjectVolatile($N, (long) $T.ARRAY_OBJECT_BASE_OFFSET + (index * (long) $T.ARRAY_OBJECT_INDEX_SCALE))", new Object[]{this.fieldModel.type, valueBuilder.unsafe(), this.field, Unsafe.class, Unsafe.class});
    }

    @Override
    void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addCode("if (!$T.equals($N, other.$N())) return false;\n", new Object[]{Objects.class, this.field, this.fieldModel.getOrGetVolatile().getName()});
    }

    @Override
    void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addCode("if (!$T.equals($N[index], other.$N(index))) return false;\n", new Object[]{Objects.class, this.field, arrayFieldModel.getOrGetVolatile().getName()});
    }

    @Override
    String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        return String.format("java.util.Objects.hashCode(%s)", this.field.name);
    }

    @Override
    String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        return String.format("java.util.Objects.hashCode(%s[index])", this.field.name);
    }
}

