/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.threads.BusyPauser;
import net.openhft.chronicle.threads.BusyTimedPauser;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.MilliPauser;
import net.openhft.chronicle.threads.TimeoutPauser;
import net.openhft.chronicle.threads.TimingPauser;
import org.jetbrains.annotations.NotNull;

public interface Pauser {
    public static final int MIN_PROCESSORS = Jvm.getInteger((String)"pauser.minProcessors", (Integer)4);
    public static final boolean BALANCED = Pauser.getBalanced();
    public static final boolean SLEEPY = Pauser.getSleepy();
    public static final int MIN_BUSY = Integer.getInteger("balances.minBusy", OS.isWindows() ? 100000 : 10000);

    public static boolean getBalanced() {
        int procs = AffinityLock.cpuLayout().cpus();
        return procs < MIN_PROCESSORS * 2;
    }

    public static boolean getSleepy() {
        int procs = AffinityLock.cpuLayout().cpus();
        return procs < MIN_PROCESSORS;
    }

    public static Pauser yielding(int minBusy) {
        SleepyWarning.warnSleepy();
        return SLEEPY ? Pauser.sleepy() : (BALANCED ? Pauser.balanced() : new TimeoutPauser(minBusy));
    }

    public static TimingPauser sleepy() {
        return new LongPauser(0, 50, 500L, Jvm.isDebug() ? 500000L : 20000L, TimeUnit.MICROSECONDS);
    }

    public static TimingPauser balanced() {
        return Pauser.balancedUpToMillis(20);
    }

    public static TimingPauser balancedUpToMillis(int millis) {
        return SLEEPY ? Pauser.sleepy() : new LongPauser(MIN_BUSY, 800, 200L, Jvm.isDebug() ? 500000L : (long)millis * 1000L, TimeUnit.MICROSECONDS);
    }

    public static MilliPauser millis(int millis) {
        return new MilliPauser(millis);
    }

    public static Pauser millis(int minMillis, int maxMillis) {
        return new LongPauser(0, 0, minMillis, maxMillis, TimeUnit.MILLISECONDS);
    }

    public static Pauser yielding() {
        return Pauser.yielding(2);
    }

    @NotNull
    public static Pauser busy() {
        SleepyWarning.warnSleepy();
        return SLEEPY ? Pauser.sleepy() : (BALANCED ? Pauser.balanced() : BusyPauser.INSTANCE);
    }

    @NotNull
    public static TimingPauser timedBusy() {
        return SLEEPY ? Pauser.sleepy() : (BALANCED ? Pauser.balanced() : new BusyTimedPauser());
    }

    public void pause();

    default public void asyncPause() {
    }

    default public boolean asyncPausing() {
        return false;
    }

    public void reset();

    default public void pause(long timeout, TimeUnit timeUnit) throws TimeoutException {
        throw new UnsupportedOperationException(this + " is not stateful, use a " + TimingPauser.class.getSimpleName());
    }

    public void unpause();

    public long timePaused();

    public long countPaused();

    default public boolean isBusy() {
        return false;
    }

    public static enum SleepyWarning {


        static void warnSleepy() {
        }

        static {
            if (SLEEPY) {
                int procs = Runtime.getRuntime().availableProcessors();
                Jvm.perf().on(Pauser.class, "Using Pauser.sleepy() as not enough processors, have " + procs + ", needs " + MIN_PROCESSORS + "+");
            } else if (BALANCED) {
                int procs = Runtime.getRuntime().availableProcessors();
                Jvm.perf().on(Pauser.class, "Using Pauser.balanced() as not enough processors, have " + procs + ", needs " + MIN_PROCESSORS * 2 + "+");
            }
        }
    }
}

