/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads.internal;

import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.ThreadHolder;
import net.openhft.chronicle.threads.ThreadMonitor;

public class ThreadMonitorHarness
implements ThreadMonitor {
    private final ThreadHolder thread;
    private long lastActionCall = Long.MAX_VALUE;

    public ThreadMonitorHarness(ThreadHolder thread) {
        this.thread = thread;
    }

    public boolean action() throws InvalidEventHandlerException {
        if (!this.thread.isAlive()) {
            this.thread.reportFinished();
            throw new InvalidEventHandlerException();
        }
        long startedNS = this.thread.startedNS();
        long nowNS = System.nanoTime();
        if (startedNS == 0L || startedNS == Long.MAX_VALUE) {
            this.thread.resetTimers();
            return false;
        }
        long actionCallDelay = nowNS - this.lastActionCall;
        this.lastActionCall = nowNS;
        if (actionCallDelay > this.thread.timingTolerance()) {
            if (this.thread.isAlive()) {
                this.thread.monitorThreadDelayed(actionCallDelay);
            }
            return true;
        }
        if (!this.thread.shouldLog(nowNS)) {
            return false;
        }
        this.thread.dumpThread(startedNS, nowNS);
        return false;
    }

    public String toString() {
        return "ThreadMonitorHarness<" + this.thread.getName() + ">";
    }
}

