/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;

public class MonitorEventLoop
implements EventLoop,
Runnable,
Closeable {
    public static final String MONITOR_INITIAL_DELAY = "MonitorInitialDelay";
    private static int MONITOR_INITIAL_DELAY_MS = Integer.getInteger("MonitorInitialDelay", 10000);
    private final ExecutorService service;
    private final EventLoop parent;
    private final List<EventHandler> handlers = new ArrayList<EventHandler>();
    private final Pauser pauser;
    private final String name;
    private volatile boolean running = true;
    private volatile boolean closed = false;

    public MonitorEventLoop(EventLoop parent, Pauser pauser) {
        this(parent, "", pauser);
    }

    public MonitorEventLoop(EventLoop parent, String name, Pauser pauser) {
        this.parent = parent;
        this.pauser = pauser;
        this.name = name + (parent == null ? "" : parent.name()) + "/event-loop-monitor";
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, true));
    }

    public String name() {
        return this.name;
    }

    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void start() {
        this.running = true;
        this.service.submit(this);
    }

    public void unpause() {
        this.pauser.unpause();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isAlive() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(@NotNull EventHandler handler) {
        if (DEBUG_ADDING_HANDLERS) {
            System.out.println("Adding " + handler.priority() + " " + handler + " to " + this.name);
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Event Group has been closed");
        }
        List<EventHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
            handler.eventLoop(this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try {
            for (int i = 0; i < MONITOR_INITIAL_DELAY_MS; i += 50) {
                if (!this.running) continue;
                Jvm.pause((long)50L);
            }
            while (this.running && !Thread.currentThread().isInterrupted()) {
                boolean busy;
                List<EventHandler> list = this.handlers;
                synchronized (list) {
                    busy = this.runHandlers();
                }
                this.pauser.pause();
                if (!busy) continue;
                this.pauser.reset();
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @HotMethod
    private boolean runHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            EventHandler handler = this.handlers.get(i);
            if (handler == null) continue;
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.handlers.remove(i--);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), "Loop terminated due to exception", (Throwable)e);
            }
        }
        return busy;
    }

    @Override
    public void close() {
        this.stop();
        Threads.shutdownDaemon(this.service);
        this.handlers.forEach(EventHandler::loopFinished);
        net.openhft.chronicle.core.io.Closeable.closeQuietly(this.handlers);
        this.closed = true;
    }
}

