/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.MilliPauser;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMonitor;
import net.openhft.chronicle.threads.ThreadMonitorEventHandler;
import net.openhft.chronicle.threads.VanillaEventLoop;
import org.jetbrains.annotations.NotNull;

public class EventGroup
implements EventLoop {
    static final long REPLICATION_MONITOR_INTERVAL_MS = Long.getLong("REPLICATION_MONITOR_INTERVAL_MS", TimeUnit.SECONDS.toMillis(15L));
    static final long MONITOR_INTERVAL_MS = Long.getLong("MONITOR_INTERVAL_MS", 200L);
    static final int CONC_THREADS = Integer.getInteger("CONC_THREADS", (Runtime.getRuntime().availableProcessors() + 2) / 2);
    private static final Integer REPLICATION_EVENT_PAUSE_TIME = Integer.getInteger("replicationEventPauseTime", 20);
    @NotNull
    final EventLoop monitor;
    @NotNull
    final VanillaEventLoop core;
    @NotNull
    final BlockingEventLoop blocking;
    @NotNull
    private final Pauser pauser;
    private final boolean binding;
    private final int bindingCpuReplication;
    private final String name;
    @NotNull
    private final VanillaEventLoop[] concThreads;
    private final MilliPauser milliPauser = Pauser.millis(50);
    private VanillaEventLoop replication;
    private Supplier<Pauser> concThreadPauserSupplier = () -> Pauser.balancedUpToMillis(REPLICATION_EVENT_PAUSE_TIME);
    private boolean daemon;

    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, int bindingCpuCore, int bindingCpuReplication, String name, int concThreads) {
        this.daemon = daemon;
        this.pauser = pauser;
        this.binding = binding;
        this.bindingCpuReplication = bindingCpuReplication;
        this.name = name;
        this.core = new VanillaEventLoop(this, name + "core-event-loop", pauser, 1L, daemon, binding, bindingCpuCore);
        this.monitor = new MonitorEventLoop(this, name, Pauser.millis(Integer.getInteger("monitor.interval", 10)));
        this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, name + "core pauser", 30));
        this.blocking = new BlockingEventLoop(this, name + "blocking-event-loop");
        this.concThreads = new VanillaEventLoop[concThreads];
    }

    public EventGroup(boolean daemon) {
        this(daemon, false);
    }

    public EventGroup(boolean daemon, boolean binding) {
        this(daemon, Pauser.balanced(), binding);
    }

    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding) {
        this(daemon, pauser, binding, -1, -1, "");
    }

    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, String name) {
        this(daemon, pauser, binding, -1, -1, name);
    }

    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, int bindingCpuCore, int bindingCpuReplication, String name) {
        this(daemon, pauser, binding, bindingCpuCore, bindingCpuReplication, name, CONC_THREADS);
    }

    protected int hash(EventHandler handler, int mod) {
        int n = handler.hashCode();
        n = n >>> 23 ^ n >>> 9 ^ n;
        n = (n & Integer.MAX_VALUE) % mod;
        return n;
    }

    public void setConcThreadPauserSupplier(Supplier<Pauser> supplier) {
        this.concThreadPauserSupplier = supplier;
    }

    synchronized VanillaEventLoop getReplication() {
        if (this.replication == null) {
            Pauser pauser = Pauser.balancedUpToMillis(REPLICATION_EVENT_PAUSE_TIME);
            this.replication = new VanillaEventLoop(this, this.name + "replication-event-loop", pauser, REPLICATION_EVENT_PAUSE_TIME.intValue(), true, this.binding, this.bindingCpuReplication);
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(REPLICATION_MONITOR_INTERVAL_MS, this.replication));
            if (this.isAlive()) {
                this.replication.start();
            }
            this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, this.name + "replication pauser", 60));
        }
        return this.replication;
    }

    private synchronized VanillaEventLoop getConcThread(int n) {
        if (this.concThreads[n] == null) {
            Pauser pauser = this.concThreadPauserSupplier.get();
            this.concThreads[n] = new VanillaEventLoop(this, this.name + "conc-event-loop-" + n, pauser, REPLICATION_EVENT_PAUSE_TIME.intValue(), this.daemon, this.binding, -1);
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(REPLICATION_MONITOR_INTERVAL_MS, this.concThreads[n]));
            if (this.isAlive()) {
                this.concThreads[n].start();
            }
            this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, this.name + "conc-event-loop-" + n + " pauser", 60));
        }
        return this.concThreads[n];
    }

    public void awaitTermination() {
        this.core.awaitTermination();
        this.blocking.awaitTermination();
        this.monitor.awaitTermination();
        if (this.replication != null) {
            this.replication.awaitTermination();
        }
        for (VanillaEventLoop concThread : this.concThreads) {
            if (concThread == null) continue;
            concThread.awaitTermination();
        }
    }

    public void unpause() {
        this.pauser.unpause();
    }

    public void addHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1) {
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                this.core.addHandler(handler);
                break;
            }
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case BLOCKING: {
                this.blocking.addHandler(handler);
                break;
            }
            case REPLICATION: {
                this.getReplication().addHandler(handler);
                break;
            }
            case CONCURRENT: {
                int n = this.hash(handler, this.concThreads.length);
                this.getConcThread(n).addHandler(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + handler.priority());
            }
        }
    }

    public void setupTimeLimitMonitor(long timeLimitNS, LongSupplier timeOfStart) {
        this.addTimingMonitor(this.name + "-monitor", timeLimitNS, timeOfStart, this.core::thread);
    }

    public void addTimingMonitor(String description, long timeLimitNS, LongSupplier timeSupplier, Supplier<Thread> threadSupplier) {
        this.milliPauser.minPauseTimeMS((timeLimitNS + 999999L) / 1000000L);
        this.addHandler(new ThreadMonitorEventHandler(description, timeLimitNS, timeSupplier, threadSupplier));
    }

    public void start() {
        if (!this.core.isAlive()) {
            this.core.start();
            this.blocking.start();
            if (this.replication != null) {
                this.replication.start();
            }
            for (VanillaEventLoop concThread : this.concThreads) {
                if (concThread == null) continue;
                concThread.start();
            }
            this.monitor.start();
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(MONITOR_INTERVAL_MS, this.core));
        }
    }

    public void stop() {
        this.monitor.stop();
        if (this.replication != null) {
            this.replication.stop();
        }
        for (VanillaEventLoop concThread : this.concThreads) {
            if (concThread == null) continue;
            concThread.stop();
        }
        this.core.stop();
        this.blocking.stop();
    }

    public boolean isClosed() {
        return this.core.isClosed();
    }

    public boolean isAlive() {
        return this.core.isAlive();
    }

    public void close() {
        this.stop();
        Closeable.closeQuietly((Object[])new Object[]{this.monitor, this.blocking, this.core});
        VanillaEventLoop replication = this.replication;
        if (replication != null) {
            Closeable.closeQuietly((Object)replication);
        }
        Closeable.closeQuietly((Object[])this.concThreads);
    }

    class LoopBlockMonitor
    implements EventHandler {
        private final long monitoryIntervalMs;
        @NotNull
        private final VanillaEventLoop eventLoop;
        long lastInterval = 1L;

        public LoopBlockMonitor(@NotNull long monitoryIntervalMs, VanillaEventLoop eventLoop) {
            this.monitoryIntervalMs = monitoryIntervalMs;
            assert (eventLoop != null);
            this.eventLoop = eventLoop;
        }

        public boolean action() throws InvalidEventHandlerException {
            long loopStartMS = this.eventLoop.loopStartMS();
            if (loopStartMS <= 0L || loopStartMS == Long.MAX_VALUE) {
                return false;
            }
            if (loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                Jvm.warn().on(this.getClass(), "Monitoring a task which has finished " + this.eventLoop);
                throw new InvalidEventHandlerException();
            }
            long now = Time.currentTimeMillis();
            long blockingTimeMS = now - loopStartMS;
            long blockingInterval = blockingTimeMS / ((this.monitoryIntervalMs + 1L) / 2L);
            if (blockingInterval > this.lastInterval && !Jvm.isDebug() && this.eventLoop.isAlive()) {
                this.eventLoop.dumpRunningState(this.eventLoop.name() + " thread has blocked for " + blockingTimeMS + " ms.", () -> this.eventLoop.loopStartMS() == loopStartMS);
            } else {
                this.lastInterval = Math.max(1L, blockingInterval);
            }
            return false;
        }
    }
}

