/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingEventLoop
implements EventLoop {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingEventLoop.class);
    @NotNull
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private volatile boolean closed;
    private EventHandler handler;

    public BlockingEventLoop(@NotNull EventLoop parent, @NotNull String name) {
        this.parent = parent;
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory(name, true));
    }

    public BlockingEventLoop(@NotNull String name) {
        this.parent = this;
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory(name, true));
    }

    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        this.addHandler(handler);
    }

    public void addHandler(@NotNull EventHandler handler) {
        block2: {
            this.handler = handler;
            try {
                this.service.submit(() -> {
                    handler.eventLoop(this.parent);
                    try {
                        while (!this.closed) {
                            handler.action();
                        }
                    }
                    catch (InvalidEventHandlerException e) {
                        Jvm.debug().on(this.getClass(), (Throwable)e);
                    }
                    catch (Throwable t) {
                        Jvm.warn().on(this.getClass(), t);
                    }
                    finally {
                        if (LOG.isDebugEnabled()) {
                            Jvm.debug().on(this.getClass(), "handler " + handler + " done.");
                        }
                        if (this.closed) {
                            Closeable.closeQuietly((Object)this.handler);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (this.closed) break block2;
                Jvm.warn().on(this.getClass(), (Throwable)e);
            }
        }
    }

    public void start() {
    }

    public void unpause() {
    }

    public void stop() {
    }

    public boolean isClosed() {
        return this.service.isShutdown();
    }

    public boolean isAlive() {
        return !this.service.isShutdown();
    }

    public void close() {
        this.closed = true;
        Closeable.closeQuietly((Object)this.handler);
        Threads.shutdown(this.service);
    }
}

