/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.BusyPauser;
import net.openhft.chronicle.threads.LongPauser;

public interface Pauser {
    public static Pauser balanced() {
        return Pauser.balancedUpToMillis(20);
    }

    public static Pauser balancedUpToMillis(int millis) {
        return new LongPauser(1000, 200, 250L, (Jvm.isDebug() ? 200000 : 0) + millis * 1000, TimeUnit.MICROSECONDS);
    }

    public static Pauser millis(int millis) {
        return Pauser.millis(millis, millis);
    }

    public static Pauser millis(int minMillis, int maxMillis) {
        return new LongPauser(0, 0, minMillis, maxMillis, TimeUnit.MILLISECONDS);
    }

    public static Pauser busy() {
        return BusyPauser.INSTANCE;
    }

    public void reset();

    public void pause();

    public void pause(long var1, TimeUnit var3) throws TimeoutException;

    public void unpause();

    public long timePaused();

    public long countPaused();
}

