/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMonitor;
import net.openhft.chronicle.threads.VanillaEventLoop;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGroup
implements EventLoop {
    static final long REPLICATION_MONITOR_INTERVAL_MS = Long.getLong("REPLICATION_MONITOR_INTERVAL_MS", TimeUnit.SECONDS.toMillis(15L));
    static final long MONITOR_INTERVAL_MS = Long.getLong("MONITOR_INTERVAL_MS", 200L);
    static final int CONC_THREADS = Integer.getInteger("CONC_THREADS", (Runtime.getRuntime().availableProcessors() + 2) / 2);
    private static final Logger LOG = LoggerFactory.getLogger(EventGroup.class);
    private static final Integer REPLICATION_EVENT_PAUSE_TIME = Integer.getInteger("replicationEventPauseTime", 20);
    final EventLoop monitor;
    @NotNull
    final VanillaEventLoop core;
    final BlockingEventLoop blocking;
    @NotNull
    private final Pauser pauser;
    private final boolean binding;
    private VanillaEventLoop _replication;
    private VanillaEventLoop[] concThreads = new VanillaEventLoop[CONC_THREADS];

    public EventGroup(boolean daemon, Pauser pauser, boolean binding) {
        this.pauser = pauser;
        this.binding = binding;
        this.core = new VanillaEventLoop(this, "core-event-loop", pauser, 1L, daemon, binding);
        this.monitor = new MonitorEventLoop(this, new LongPauser(0, 0, 1L, 1L, TimeUnit.SECONDS));
        this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, "core pauser", 30));
        this.blocking = new BlockingEventLoop(this, "blocking-event-loop");
    }

    public EventGroup(boolean daemon) {
        this(daemon, new LongPauser(500, 100, 500L, Jvm.isDebug() ? 200000L : 20000L, TimeUnit.MICROSECONDS), false);
    }

    static int hash(int n, int mod) {
        n = n >>> 23 ^ n >>> 9 ^ n;
        n = (n & Integer.MAX_VALUE) % mod;
        return n;
    }

    synchronized VanillaEventLoop getReplication() {
        if (this._replication == null) {
            LongPauser pauser = new LongPauser(1, 50, 500L, Jvm.isDebug() ? 200000L : (long)(REPLICATION_EVENT_PAUSE_TIME * 1000), TimeUnit.MICROSECONDS);
            this._replication = new VanillaEventLoop(this, "replication-event-loop", pauser, REPLICATION_EVENT_PAUSE_TIME.intValue(), true, this.binding);
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(REPLICATION_MONITOR_INTERVAL_MS, this._replication));
            this._replication.start();
            this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, "replication pauser", 60));
        }
        return this._replication;
    }

    synchronized VanillaEventLoop getIOThread(int n) {
        if (this.concThreads[n] == null) {
            LongPauser pauser = new LongPauser(1, 50, 500L, Jvm.isDebug() ? 200000L : (long)(REPLICATION_EVENT_PAUSE_TIME * 1000), TimeUnit.MICROSECONDS);
            this._replication = new VanillaEventLoop(this, "conc-event-loop-" + n, pauser, REPLICATION_EVENT_PAUSE_TIME.intValue(), true, this.binding);
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(REPLICATION_MONITOR_INTERVAL_MS, this._replication));
            this._replication.start();
            this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, "conc-event-loop-" + n + " pauser", 60));
        }
        return this._replication;
    }

    public void unpause() {
        this.pauser.unpause();
    }

    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        this.addHandler(handler);
    }

    public void addHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1) {
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                this.core.addHandler(handler);
                break;
            }
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case BLOCKING: {
                this.blocking.addHandler(handler);
                break;
            }
            case REPLICATION: {
                this.getReplication().addHandler(handler);
                break;
            }
            case CONCURRENT: {
                int n = EventGroup.hash(handler.hashCode(), CONC_THREADS);
                this.getIOThread(n).addHandler(handler);
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + handler.priority());
            }
        }
    }

    public void start() {
        if (!this.core.isAlive()) {
            this.core.start();
            this.monitor.start();
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(MONITOR_INTERVAL_MS, this.core));
        }
    }

    public void stop() {
        this.monitor.stop();
        if (this._replication != null) {
            this._replication.stop();
        }
        this.core.stop();
        this.blocking.stop();
    }

    public boolean isClosed() {
        return this.core.isClosed();
    }

    public boolean isAlive() {
        return this.core.isAlive();
    }

    public void close() {
        this.stop();
        this.monitor.close();
        this.blocking.close();
        this.core.close();
        if (this._replication != null) {
            this._replication.close();
        }
    }

    class LoopBlockMonitor
    implements EventHandler {
        private final long monitoryIntervalMs;
        private final VanillaEventLoop eventLoop;
        long lastInterval = 1L;

        public LoopBlockMonitor(long monitoryIntervalMs, VanillaEventLoop eventLoop) {
            this.monitoryIntervalMs = monitoryIntervalMs;
            this.eventLoop = eventLoop;
        }

        public boolean action() throws InvalidEventHandlerException {
            long loopStartMS = this.eventLoop.loopStartMS();
            if (loopStartMS <= 0L || loopStartMS == Long.MAX_VALUE) {
                return false;
            }
            if (loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                Jvm.warn().on(this.getClass(), "Monitoring a task which has finished " + this.eventLoop);
                throw new InvalidEventHandlerException();
            }
            long now = Time.currentTimeMillis();
            long blockingTimeMS = now - loopStartMS;
            long blockingInterval = blockingTimeMS / (this.monitoryIntervalMs / 2L);
            if (blockingInterval > this.lastInterval && !Jvm.isDebug() && this.eventLoop.isAlive()) {
                this.eventLoop.dumpRunningState(this.eventLoop.name() + " thread has blocked for " + blockingTimeMS + " ms.", () -> this.eventLoop.loopStartMS() == loopStartMS);
            } else {
                this.lastInterval = Math.max(1L, blockingInterval);
            }
            return false;
        }
    }
}

