/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.ThrowingCallable;
import org.jetbrains.annotations.NotNull;

public enum Threads {

    static final Field GROUP = Jvm.getField(Thread.class, (String)"group");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static <R, T extends Throwable> R withThreadGroup(ThreadGroup tg, @NotNull ThrowingCallable<R, T> callable) throws T {
        Thread thread = Thread.currentThread();
        ThreadGroup tg0 = thread.getThreadGroup();
        Threads.setThreadGroup(thread, tg);
        try {
            Object object = callable.call();
            return (R)object;
        }
        finally {
            Threads.setThreadGroup(thread, tg0);
        }
    }

    @ForceInline
    public static void setThreadGroup(Thread thread, ThreadGroup tg) {
        try {
            GROUP.set(thread, tg);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static String threadGroupPrefix() {
        String threadGroupName = Thread.currentThread().getThreadGroup().getName();
        if (!threadGroupName.endsWith("/")) {
            threadGroupName = threadGroupName + "/";
        }
        return threadGroupName;
    }

    public static void shutdown(@NotNull ExecutorService service) {
        block9: {
            service.shutdown();
            try {
                if (service.awaitTermination(1L, TimeUnit.SECONDS)) break block9;
                service.shutdownNow();
                try {
                    if (service.awaitTermination(20L, TimeUnit.SECONDS)) break block9;
                    if (service instanceof ThreadPoolExecutor) {
                        try {
                            Field workers = ThreadPoolExecutor.class.getDeclaredField("workers");
                            workers.setAccessible(true);
                            Set objects = (Set)workers.get(service);
                            for (Object o : objects) {
                                Field thread = o.getClass().getDeclaredField("thread");
                                thread.setAccessible(true);
                                Thread t = (Thread)thread.get(o);
                                if (t.getState() == Thread.State.TERMINATED) continue;
                                StringBuilder b = new StringBuilder("**** THE FOLLOWING THREAD DID NOT SHUTDOWN ***\n");
                                for (StackTraceElement s : t.getStackTrace()) {
                                    b.append("  " + s.toString() + "\n");
                                }
                                Jvm.warn().on(Threads.class, b.toString());
                            }
                            break block9;
                        }
                        catch (Exception e) {
                            Jvm.warn().on(Threads.class, (Throwable)e);
                            break block9;
                        }
                    }
                    service.shutdownNow();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

