/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaEventLoop
implements EventLoop,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaEventLoop.class);
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private final List<EventHandler> highHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> mediumHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> timerHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> daemonHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final AtomicReference<EventHandler> newHandler = new AtomicReference();
    private final Queue<EventHandler> newHandlerQueue = new LinkedTransferQueue<EventHandler>();
    private final Pauser pauser;
    private final long timerIntervalMS;
    private final String name;
    private final Consumer<Throwable> onThrowable;
    private long lastTimerNS;
    private volatile long loopStartMS;
    @NotNull
    private volatile AtomicBoolean running = new AtomicBoolean();
    @Nullable
    private volatile Thread thread = null;
    @Nullable
    private volatile Throwable closedHere = null;

    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.timerIntervalMS = timerIntervalMS;
        this.loopStartMS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon));
        this.onThrowable = t -> LOG.error("", t);
    }

    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, Consumer<Throwable> onThrowable) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.timerIntervalMS = timerIntervalMS;
        this.loopStartMS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon));
        this.onThrowable = onThrowable;
    }

    @Override
    public void start() {
        if (this.closedHere != null) {
            throw new IllegalStateException("Event Group has been closed", this.closedHere);
        }
        if (!this.running.getAndSet(true)) {
            this.service.submit(this);
        }
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
        this.running.set(false);
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        this.addHandler(false, handler);
    }

    @Override
    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
        } else {
            if (!this.running.get()) {
                if (!dontAttemptToRunImmediatelyInCurrentThread) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Running " + handler + " in the current thread as " + this + " has finished");
                        }
                        handler.action();
                    }
                    catch (InvalidEventHandlerException invalidEventHandlerException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.pauser.unpause();
            if (!this.newHandler.compareAndSet(null, handler)) {
                this.newHandlerQueue.add(handler);
            }
        }
    }

    public long loopStartMS() {
        return this.loopStartMS;
    }

    @Override
    @HotMethod
    public void run() {
        try {
            this.thread = Thread.currentThread();
            while (this.running.get()) {
                boolean busy = false;
                if (this.highHandlers.isEmpty()) {
                    this.loopStartMS = Time.currentTimeMillis();
                    busy |= this.runAllLowHandler();
                } else {
                    for (int i = 0; i < 10; ++i) {
                        this.loopStartMS = Time.currentTimeMillis();
                        busy |= this.runAllHighHandlers();
                        busy |= this.runOneTenthLowHandler(i);
                    }
                }
                if (this.lastTimerNS + this.timerIntervalMS < this.loopStartMS) {
                    this.lastTimerNS = this.loopStartMS;
                    this.runTimerHandlers();
                }
                if (busy |= this.acceptNewHandlers()) {
                    this.pauser.reset();
                    continue;
                }
                this.runDaemonHandlers();
                this.loopStartMS = Long.MAX_VALUE;
                this.pauser.pause();
            }
        }
        catch (Throwable e) {
            this.onThrowable.accept(e);
        }
        finally {
            this.loopStartMS = 0x7FFFFFFFFFFFFFFEL;
        }
    }

    @HotMethod
    private boolean runAllHighHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.highHandlers.size(); ++i) {
            EventHandler handler = this.highHandlers.get(i);
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                block6: {
                    try {
                        this.highHandlers.remove(i--);
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {
                        if (this.mediumHandlers.isEmpty()) break block6;
                        throw e2;
                    }
                }
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        return busy;
    }

    @HotMethod
    private boolean runOneTenthLowHandler(int i) {
        boolean busy = false;
        for (int j = i; j < this.mediumHandlers.size(); j += 10) {
            EventHandler handler = this.mediumHandlers.get(j);
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                block6: {
                    try {
                        this.mediumHandlers.remove(j);
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {
                        if (this.mediumHandlers.isEmpty()) break block6;
                        throw e2;
                    }
                }
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        return busy;
    }

    @HotMethod
    private boolean runAllLowHandler() {
        boolean busy = false;
        for (int j = 0; j < this.mediumHandlers.size(); ++j) {
            EventHandler handler = this.mediumHandlers.get(j);
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                block6: {
                    try {
                        this.mediumHandlers.remove(j);
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {
                        if (this.mediumHandlers.isEmpty()) break block6;
                        throw e2;
                    }
                }
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        return busy;
    }

    @HotMethod
    private void runTimerHandlers() {
        for (int i = 0; i < this.timerHandlers.size(); ++i) {
            EventHandler handler = this.timerHandlers.get(i);
            try {
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                block6: {
                    try {
                        this.timerHandlers.remove(i--);
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {
                        if (this.timerHandlers.isEmpty()) break block6;
                        throw e2;
                    }
                }
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    @HotMethod
    private void runDaemonHandlers() {
        for (int i = 0; i < this.daemonHandlers.size(); ++i) {
            EventHandler handler = this.daemonHandlers.get(i);
            try {
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                block6: {
                    try {
                        this.daemonHandlers.remove(i--);
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {
                        if (this.daemonHandlers.isEmpty()) break block6;
                        throw e2;
                    }
                }
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    @HotMethod
    private boolean acceptNewHandlers() {
        boolean busy = false;
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
            busy = true;
        }
        while ((handler = this.newHandlerQueue.poll()) != null) {
            this.addNewHandler(handler);
            busy = true;
        }
        return busy;
    }

    private void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1 == null ? HandlerPriority.MEDIUM : t1) {
            case HIGH: {
                if (this.highHandlers.contains(handler)) break;
                this.highHandlers.add(handler);
                break;
            }
            case REPLICATION: 
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                this.mediumHandlers.add(handler);
                break;
            }
            case TIMER: {
                if (this.timerHandlers.contains(handler)) break;
                this.timerHandlers.add(handler);
                break;
            }
            case DAEMON: {
                if (this.daemonHandlers.contains(handler)) break;
                this.daemonHandlers.add(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
            }
        }
        handler.eventLoop(this.parent);
    }

    public String name() {
        return this.name;
    }

    public void dumpRunningState(@NotNull String message, @NotNull BooleanSupplier finalCheck) {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        Jvm.trimStackTrace((StringBuilder)out, (StackTraceElement[])thread.getStackTrace());
        if (finalCheck.getAsBoolean() && LOG.isInfoEnabled()) {
            LOG.info(out.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            EventHandler o;
            this.closedHere = new Throwable("Closed here");
            this.highHandlers.forEach(Closeable::closeQuietly);
            this.mediumHandlers.forEach(Closeable::closeQuietly);
            this.daemonHandlers.forEach(Closeable::closeQuietly);
            this.timerHandlers.forEach(Closeable::closeQuietly);
            Optional.ofNullable(this.newHandler.get()).ifPresent(Closeable::closeQuietly);
            while ((o = this.newHandlerQueue.poll()) != null) {
                Closeable.closeQuietly((Object)o);
            }
            this.service.shutdown();
            this.pauser.unpause();
            this.thread.interrupt();
            if (!this.service.awaitTermination(1L, TimeUnit.SECONDS)) {
                Thread thread = this.thread;
                if (thread != null) {
                    StackTraceElement[] stackTrace = thread.getStackTrace();
                    StringBuilder sb = new StringBuilder(thread + " still running ");
                    Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stackTrace);
                    LOG.info(sb.toString());
                }
                this.service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
        finally {
            this.highHandlers.clear();
            this.mediumHandlers.clear();
            this.daemonHandlers.clear();
            this.timerHandlers.clear();
            this.newHandlerQueue.clear();
            this.newHandler.set(null);
        }
    }

    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }
}

