/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.ref.WeakReference;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PauserMonitor
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PauserMonitor.class);
    private final WeakReference<Pauser> pauser;
    private final String description;
    private final int mills;
    private long nextLongTime = 0L;
    private long lastTime = 0L;
    private long lastTimePaused = 0L;
    private long lastCountPaused = 0L;

    public PauserMonitor(Pauser pauser, String description, int seconds) {
        this.pauser = new WeakReference<Pauser>(pauser);
        this.description = description;
        this.mills = seconds * 1000;
    }

    @Override
    public boolean action() throws InvalidEventHandlerException {
        long now = System.currentTimeMillis();
        if (this.nextLongTime > now) {
            return false;
        }
        Pauser pauser = (Pauser)this.pauser.get();
        if (pauser == null) {
            throw new InvalidEventHandlerException();
        }
        long timePaused = pauser.timePaused();
        long countPaused = pauser.countPaused();
        if (this.nextLongTime > 0L) {
            long timeDelta = now - this.lastTime;
            long timePausedDelta = timePaused - this.lastTimePaused;
            long countPausedDelta = countPaused - this.lastCountPaused;
            if (countPausedDelta > 0L) {
                double averageTime = (double)(timePausedDelta * 1000L / countPausedDelta) / 1000.0;
                double busy = Math.abs((double)((timeDelta - timePausedDelta) * 1000L / timeDelta) / 10.0);
                LOG.info(this.description + ": avg pause: " + averageTime + " ms, " + "count=" + countPausedDelta + (this.lastTime > 0L ? ", busy=" + busy + "%" : ""));
            } else {
                LOG.info(this.description + ": count=" + countPausedDelta + ", busy=100%");
            }
        }
        this.lastTimePaused = timePaused;
        this.lastCountPaused = countPaused;
        this.nextLongTime = now + (long)this.mills;
        this.lastTime = now;
        return true;
    }

    @Override
    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.MONITOR;
    }
}

