/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMonitor;
import net.openhft.chronicle.threads.VanillaEventLoop;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGroup
implements EventLoop {
    static final long REPLICATION_MONITOR_INTERVAL_MS = Long.getLong("REPLICATION_MONITOR_INTERVAL_MS", TimeUnit.SECONDS.toMillis(15L));
    static final long MONITOR_INTERVAL_MS = Long.getLong("MONITOR_INTERVAL_MS", 200L);
    private static final Logger LOG = LoggerFactory.getLogger(EventGroup.class);
    private static final Integer REPLICATION_EVENT_PAUSE_TIME = Integer.getInteger("replicationEventPauseTime", 20);
    final EventLoop monitor = new MonitorEventLoop(this, new LongPauser(0, 0, 1L, 1L, TimeUnit.SECONDS));
    @NotNull
    final VanillaEventLoop core;
    final BlockingEventLoop blocking = new BlockingEventLoop(this, "blocking-event-loop");
    private final Consumer<Throwable> onThrowable;
    @NotNull
    private final Pauser pauser;
    private VanillaEventLoop _replication;

    public EventGroup(boolean daemon, Consumer<Throwable> onThrowable) {
        this.onThrowable = onThrowable;
        this.pauser = new LongPauser(100, 100, 1L, Jvm.isDebug() ? 20L : 200L, TimeUnit.MILLISECONDS);
        this.monitor.addHandler(new PauserMonitor(this.pauser, "core pauser", 10));
        this.core = new VanillaEventLoop(this, "core-event-loop", this.pauser, 1L, daemon);
    }

    public EventGroup(boolean daemon) {
        this(daemon, Throwable::printStackTrace);
    }

    public synchronized VanillaEventLoop getReplication() {
        if (this._replication == null) {
            LongPauser pauser = new LongPauser(0, 1, 1L, REPLICATION_EVENT_PAUSE_TIME.intValue(), TimeUnit.MILLISECONDS);
            this._replication = new VanillaEventLoop(this, "replication-event-loop", pauser, REPLICATION_EVENT_PAUSE_TIME.intValue(), true, this.onThrowable);
            this.monitor.addHandler(new LoopBlockMonitor(REPLICATION_MONITOR_INTERVAL_MS, this._replication));
            this._replication.start();
            this.monitor.addHandler(new PauserMonitor(pauser, "replication pauser", 10));
        }
        return this._replication;
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        this.addHandler(handler);
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1) {
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                this.core.addHandler(handler);
                break;
            }
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case BLOCKING: {
                this.blocking.addHandler(handler);
                break;
            }
            case REPLICATION: {
                this.getReplication().addHandler(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + (Object)((Object)handler.priority()));
            }
        }
    }

    @Override
    public void start() {
        if (!this.core.isAlive()) {
            this.core.start();
            this.monitor.start();
            this.monitor.addHandler(new LoopBlockMonitor(MONITOR_INTERVAL_MS, this.core));
        }
    }

    @Override
    public void stop() {
        this.monitor.stop();
        if (this._replication != null) {
            this._replication.stop();
        }
        this.core.stop();
        this.blocking.stop();
    }

    @Override
    public void close() throws IOException {
        this.stop();
        this.monitor.close();
        this.blocking.close();
        this.core.close();
        if (this._replication != null) {
            this._replication.close();
        }
    }

    class LoopBlockMonitor
    implements EventHandler {
        private final long monitoryIntervalMs;
        private final VanillaEventLoop eventLoop;
        long lastInterval = 1L;

        public LoopBlockMonitor(long monitoryIntervalMs, VanillaEventLoop eventLoop) {
            this.monitoryIntervalMs = monitoryIntervalMs;
            this.eventLoop = eventLoop;
        }

        @Override
        public boolean action() throws InvalidEventHandlerException {
            long loopStartMS = this.eventLoop.loopStartMS();
            if (loopStartMS <= 0L || loopStartMS == Long.MAX_VALUE) {
                return false;
            }
            if (loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                LOG.warn("Monitoring a task which has finished");
                throw new InvalidEventHandlerException();
            }
            long now = Time.currentTimeMillis();
            long blockingTimeMS = now - loopStartMS;
            long blockingInterval = blockingTimeMS / (this.monitoryIntervalMs / 2L);
            if (blockingInterval > this.lastInterval && !Jvm.isDebug() && this.eventLoop.isAlive()) {
                this.eventLoop.dumpRunningState(this.eventLoop.name() + " thread has blocked for " + blockingTimeMS + " ms.", () -> this.eventLoop.loopStartMS() == loopStartMS);
            } else {
                this.lastInterval = Math.max(1L, blockingInterval);
            }
            return false;
        }
    }
}

