/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.threads.Pauser;

public class LongPauser
implements Pauser {
    private final int timeMs;
    private int count;

    public LongPauser(long time, TimeUnit timeUnit) {
        this.timeMs = Maths.toUInt31((long)timeUnit.toMillis(time));
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void pause() {
        if (this.count++ == 0) {
            return;
        }
        if (this.count > this.timeMs) {
            this.count = this.timeMs;
        }
        Jvm.pause((long)this.count);
    }

    @Override
    public void pause(long maxPauseNS) {
        if (this.count++ == 0) {
            return;
        }
        if (this.count > this.timeMs) {
            this.count = this.timeMs;
        }
        Jvm.pause((long)Math.min((long)this.count, maxPauseNS / 1000000L));
    }

    @Override
    public void unpause() {
    }
}

