/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.LightPauser;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.VanillaEventLoop;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGroup
implements EventLoop {
    static final long MONITOR_INTERVAL_MS = 200L;
    private static final Logger LOG = LoggerFactory.getLogger(EventGroup.class);
    final EventLoop monitor = new MonitorEventLoop(this, new LightPauser(-1L, TimeUnit.SECONDS.toNanos(1L)));
    @NotNull
    final VanillaEventLoop core;
    final VanillaEventLoop replication;
    final BlockingEventLoop blocking = new BlockingEventLoop(this, "blocking-event-loop");
    @NotNull
    private final LightPauser pauser = new LightPauser(TimeUnit.NANOSECONDS.convert(20L, Jvm.isDebug() ? TimeUnit.MILLISECONDS : TimeUnit.MICROSECONDS), TimeUnit.NANOSECONDS.convert(200L, Jvm.isDebug() ? TimeUnit.MILLISECONDS : TimeUnit.MICROSECONDS));

    public EventGroup(boolean daemon) {
        this.core = new VanillaEventLoop(this, "core-event-loop", this.pauser, 1L, daemon);
        this.replication = new VanillaEventLoop(this, "replication-event-loop", this.pauser, 1L, daemon);
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1) {
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                this.core.addHandler(handler);
                break;
            }
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case BLOCKING: {
                this.blocking.addHandler(handler);
                break;
            }
            case REPLICATION: {
                this.replication.addHandler(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + (Object)((Object)handler.priority()));
            }
        }
    }

    @Override
    public void start() {
        if (!this.core.isAlive()) {
            this.core.start();
            this.monitor.start();
            this.monitor.addHandler(new LoopBlockMonitor());
        }
    }

    @Override
    public void stop() {
        this.monitor.stop();
        this.core.stop();
    }

    @Override
    public void close() throws IOException {
        this.stop();
        this.monitor.close();
        this.blocking.close();
        this.core.close();
    }

    class LoopBlockMonitor
    implements EventHandler {
        long lastInterval = 1L;
        long started = Time.currentTimeMillis();

        LoopBlockMonitor() {
        }

        @Override
        public boolean action() throws InvalidEventHandlerException {
            long loopStartMS = EventGroup.this.core.loopStartMS();
            if (loopStartMS <= 0L || loopStartMS == Long.MAX_VALUE) {
                return false;
            }
            if (loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                LOG.warn("Monitoring a task which has finished");
                throw new InvalidEventHandlerException();
            }
            long now = Time.currentTimeMillis();
            long blockingTimeMS = now - loopStartMS;
            long blockingInterval = blockingTimeMS / 100L;
            if (blockingInterval > this.lastInterval && !Jvm.isDebug() && EventGroup.this.core.isAlive()) {
                EventGroup.this.core.dumpRunningState(EventGroup.this.core.name() + " thread has blocked for " + blockingTimeMS + " ms.", () -> EventGroup.this.core.loopStartMS() == loopStartMS);
            } else {
                this.lastInterval = Math.max(1L, blockingInterval);
            }
            return false;
        }
    }
}

