/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaEventLoop
implements EventLoop,
Runnable {
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    private final List<EventHandler> highHandlers = new ArrayList<EventHandler>();
    private final List<EventHandler> mediumHandlers = new ArrayList<EventHandler>();
    private final List<EventHandler> timerHandlers = new ArrayList<EventHandler>();
    private final List<EventHandler> daemonHandlers = new ArrayList<EventHandler>();
    private final AtomicReference<EventHandler> newHandler = new AtomicReference();
    private final Pauser pauser;
    private final long timerIntervalMS;
    private final String name;
    private long lastTimerNS;
    private volatile long loopStartMS;
    private volatile AtomicBoolean running = new AtomicBoolean();
    @Nullable
    private volatile Thread thread = null;

    public VanillaEventLoop(EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon) {
        this.parent = parent;
        this.name = name;
        this.pauser = pauser;
        this.timerIntervalMS = timerIntervalMS;
        this.loopStartMS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon));
    }

    @Override
    public void start() {
        if (!this.running.getAndSet(true)) {
            this.service.submit(this);
        }
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
        this.running.set(false);
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
        } else {
            this.pauser.unpause();
            while (!this.newHandler.compareAndSet(null, handler)) {
                Thread.yield();
            }
        }
    }

    public long loopStartMS() {
        return this.loopStartMS;
    }

    @Override
    @HotMethod
    public void run() {
        try {
            this.thread = Thread.currentThread();
            while (this.running.get()) {
                boolean busy = false;
                for (int i = 0; i < 10; ++i) {
                    this.loopStartMS = Time.currentTimeMillis();
                    busy |= this.runAllHighHandlers();
                    busy |= this.runOneTenthLowHandler(i);
                }
                if (this.lastTimerNS + this.timerIntervalMS < this.loopStartMS) {
                    this.lastTimerNS = this.loopStartMS;
                    this.runTimerHandlers();
                }
                this.acceptNewHandlers();
                if (busy) {
                    this.pauser.reset();
                    continue;
                }
                this.runDaemonHandlers();
                this.loopStartMS = Long.MAX_VALUE;
                this.pauser.pause();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @HotMethod
    private boolean runAllHighHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.highHandlers.size(); ++i) {
            EventHandler handler = this.highHandlers.get(i);
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.highHandlers.remove(i--);
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return busy;
    }

    @HotMethod
    private boolean runOneTenthLowHandler(int i) {
        boolean busy = false;
        for (int j = i; j < this.mediumHandlers.size(); j += 10) {
            EventHandler handler = this.mediumHandlers.get(j);
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.mediumHandlers.remove(i--);
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return busy;
    }

    @HotMethod
    private void runTimerHandlers() {
        for (int i = 0; i < this.timerHandlers.size(); ++i) {
            EventHandler handler = this.timerHandlers.get(i);
            try {
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.timerHandlers.remove(i--);
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @HotMethod
    private void runDaemonHandlers() {
        for (int i = 0; i < this.daemonHandlers.size(); ++i) {
            EventHandler handler = this.daemonHandlers.get(i);
            try {
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.daemonHandlers.remove(i--);
                Closeable.closeQuietly((Object)handler);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @HotMethod
    private void acceptNewHandlers() {
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
        }
    }

    private void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1 == null ? HandlerPriority.MEDIUM : t1) {
            case HIGH: {
                if (this.highHandlers.contains(handler)) break;
                this.highHandlers.add(handler);
                break;
            }
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                this.mediumHandlers.add(handler);
                break;
            }
            case TIMER: 
            case DAEMON: {
                if (this.daemonHandlers.contains(handler)) break;
                this.daemonHandlers.add(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + (Object)((Object)handler.priority()) + " task to a busy waiting thread");
            }
        }
        handler.eventLoop(this.parent);
    }

    public String name() {
        return this.name;
    }

    public void dumpRunningState(@NotNull String message, BooleanSupplier finalCheck) {
        Thread thread = this.thread;
        if (thread == null) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        Jvm.trimStackTrace((StringBuilder)out, (StackTraceElement[])thread.getStackTrace());
        if (finalCheck.getAsBoolean()) {
            System.out.println(out);
        }
    }

    @Override
    public void close() {
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
    }

    public boolean isAlive() {
        Thread thread = this.thread;
        return thread != null && thread.isAlive();
    }
}

