/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.LightPauser;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.VanillaEventLoop;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import org.jetbrains.annotations.NotNull;

public class EventGroup
implements EventLoop {
    static final long MONITOR_INTERVAL_MS = 200L;
    final EventLoop monitor = new MonitorEventLoop(this, new LightPauser(-1L, TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS)));
    final VanillaEventLoop core;
    final BlockingEventLoop blocking = new BlockingEventLoop(this, "blocking-event-loop");
    private final LightPauser pauser = new LightPauser(TimeUnit.NANOSECONDS.convert(20L, Jvm.isDebug() ? TimeUnit.MILLISECONDS : TimeUnit.MICROSECONDS), TimeUnit.NANOSECONDS.convert(200L, Jvm.isDebug() ? TimeUnit.MILLISECONDS : TimeUnit.MICROSECONDS));

    public EventGroup(boolean daemon) {
        this.core = new VanillaEventLoop(this, "core-event-loop", this.pauser, 1L, daemon);
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1 == null ? HandlerPriority.BLOCKING : t1) {
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                this.core.addHandler(handler);
                break;
            }
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case BLOCKING: {
                this.blocking.addHandler(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + (Object)((Object)handler.priority()));
            }
        }
    }

    @Override
    public void start() {
        this.core.start();
        this.monitor.start();
        this.monitor.addHandler(new LoopBlockMonitor());
    }

    @Override
    public void stop() {
        this.monitor.stop();
        this.core.stop();
    }

    @Override
    public void close() throws IOException {
        this.stop();
        this.monitor.close();
        this.blocking.close();
        this.core.close();
    }

    class LoopBlockMonitor
    implements EventHandler {
        long lastInterval = 1L;

        LoopBlockMonitor() {
        }

        @Override
        public boolean action() {
            long loopStartMS = EventGroup.this.core.loopStartMS();
            if (loopStartMS <= 0L || loopStartMS == Long.MAX_VALUE) {
                return false;
            }
            long blockingTimeMS = Time.currentTimeMillis() - loopStartMS;
            long blockingInterval = blockingTimeMS / 100L;
            if (blockingInterval > this.lastInterval && !Jvm.IS_DEBUG && EventGroup.this.core.isAlive()) {
                EventGroup.this.core.dumpRunningState(EventGroup.this.core.name() + " thread has blocked for " + blockingTimeMS + " ms.", () -> EventGroup.this.core.loopStartMS() == loopStartMS);
            } else {
                this.lastInterval = Math.max(1L, blockingInterval);
            }
            return false;
        }
    }
}

