/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.salt.Sodium;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SealedBox {


    @NotNull
    public static BytesStore encrypt(@NotNull BytesStore message, @NotNull PublicKey publicKey) {
        return SealedBox.encrypt(null, message, publicKey);
    }

    @NotNull
    public static BytesStore encrypt(@Nullable BytesStore result, @NotNull BytesStore message, @NotNull PublicKey publicKey) {
        return SealedBox.encrypt(result, message, publicKey.store);
    }

    @NotNull
    public static BytesStore encrypt(@Nullable BytesStore result, @NotNull BytesStore message, @NotNull BytesStore publicKey) {
        if (publicKey == null) {
            throw new RuntimeException("Encryption failed. Public key not available.");
        }
        long length = message.readRemaining();
        long resultLength = length + 48L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Sodium.SODIUM.crypto_box_seal(result.addressForWrite(0L), message.addressForRead(message.readPosition()), (int)length, publicKey.addressForRead(publicKey.readPosition())), "Encryption failed");
        return result;
    }

    @NotNull
    public static BytesStore decrypt(@NotNull BytesStore ciphertext, @NotNull PublicKey publicKey, @NotNull SecretKey secretKey) {
        return SealedBox.decrypt(null, ciphertext, publicKey, secretKey);
    }

    @NotNull
    public static BytesStore decrypt(@Nullable BytesStore result, @NotNull BytesStore ciphertext, @NotNull PublicKey publicKey, @NotNull SecretKey secretKey) {
        return SealedBox.decrypt(result, ciphertext, publicKey.store, secretKey.store);
    }

    @NotNull
    public static BytesStore decrypt(@Nullable BytesStore result, @NotNull BytesStore ciphertext, @NotNull BytesStore publicKey, @NotNull BytesStore secretKey) {
        if (publicKey == null) {
            throw new RuntimeException("Decryption failed. Public key not available.");
        }
        if (secretKey == null) {
            throw new RuntimeException("Decryption failed. Private key not available.");
        }
        long length = ciphertext.readRemaining();
        long resultLength = length - 48L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Sodium.SODIUM.crypto_box_seal_open(result.addressForWrite(0L), ciphertext.addressForRead(ciphertext.readPosition()), (int)length, publicKey.addressForRead(publicKey.readPosition()), secretKey.addressForRead(secretKey.readPosition())), "Decryption failed. Ciphertext failed verification");
        return result;
    }

    public static class KeyPair {
        public final PublicKey publicKey;
        public final SecretKey secretKey = new SecretKey();

        private KeyPair() {
            this.publicKey = new PublicKey();
            Sodium.SODIUM.crypto_box_keypair(this.publicKey.address(), this.secretKey.address());
        }

        public static KeyPair generate() {
            return new KeyPair();
        }

        public void wipe() {
            this.secretKey.wipe();
        }
    }

    public static class SecretKey {
        public final BytesStore store = Bytes.allocateDirect((long)32L);

        private SecretKey() {
            ((Bytes)this.store).readLimit(32L);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }

        public void wipe() {
            Sodium.SODIUM.sodium_memzero(this.address(), 32L);
        }
    }

    public static class PublicKey {
        public final BytesStore store = Bytes.allocateDirect((long)32L);

        private PublicKey() {
            ((Bytes)this.store).readLimit(32L);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }
    }
}

