/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.openhft.chronicle.core.OS;

public class Bridge {
    public static final boolean LOADED;

    public static native int crypto_box_easy(long var0, long var2, long var4, long var6, long var8, long var10);

    public static native int crypto_box_open_easy(long var0, long var2, long var4, long var6, long var8, long var10);

    static {
        boolean loaded = false;
        try {
            try {
                CodeSource src = Bridge.class.getProtectionDomain().getCodeSource();
                if (src != null) {
                    String destDir = OS.getTarget();
                    String osname = System.getProperty("os.name").toLowerCase();
                    String arch = System.getProperty("os.arch").toLowerCase();
                    String pattern = osname + File.separator + arch;
                    String jarFile = src.getLocation().getFile();
                    JarFile jar = new JarFile(jarFile);
                    Enumeration<JarEntry> enumEntries = jar.entries();
                    while (enumEntries.hasMoreElements()) {
                        File parent;
                        JarEntry file = enumEntries.nextElement();
                        if (!file.getName().contains(pattern)) continue;
                        File f = new File(destDir + File.separator + file.getName());
                        if (!f.exists() && (parent = f.getParentFile()) != null) {
                            parent.mkdirs();
                            f = new File(destDir + File.separator + file.getName());
                        }
                        if (file.isDirectory()) continue;
                        System.out.println("Unpacking " + file.getName() + " to " + f.toString());
                        InputStream is = jar.getInputStream(file);
                        FileOutputStream fos = new FileOutputStream(f);
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                        fos.close();
                        is.close();
                    }
                    jar.close();
                    String libpath = System.getProperty("java.library.path");
                    libpath = libpath + File.pathSeparator + destDir + File.separator + pattern;
                    try {
                        System.setProperty("java.library.path", libpath);
                        Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                        fieldSysPath.setAccessible(true);
                        fieldSysPath.set(null, null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                }
            }
            catch (FileNotFoundException src) {
            }
            catch (IOException src) {
                // empty catch block
            }
            try {
                URL url = Bridge.class.getClassLoader().getResource("libbridge.so");
                if (url != null) {
                    System.load(url.getFile());
                    loaded = true;
                }
            }
            catch (Exception url) {
                // empty catch block
            }
            if (!loaded) {
                System.loadLibrary("bridge");
            }
            loaded = true;
        }
        catch (UnsatisfiedLinkError ule) {
            loaded = false;
        }
        LOADED = loaded;
    }
}

