/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import javax.xml.bind.DatatypeConverter;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Platform;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.byref.LongLongByReference;
import jnr.ffi.types.caddr_t;
import jnr.ffi.types.u_int64_t;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Sodium {
    public static final String STANDARD_GROUP_ELEMENT = "0900000000000000000000000000000000000000000000000000000000000000";
    public static final BytesStore<?, ?> SGE_BYTES = Init.fromHex(0, "0900000000000000000000000000000000000000000000000000000000000000");
    public static final int ED25519_PUBLICKEY_BYTES = 32;
    public static final int ED25519_PRIVATEKEY_BYTES = 32;
    public static final int ED25519_SECRETKEY_BYTES = 64;
    public static final Sodium SODIUM = Init.init();
    public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_PUBLICKEYBYTES = 32;
    public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_SECRETKEYBYTES = 32;
    public static final int SIZEOF_CRYPTO_HASH_BLAKE2B_STATE = 384;
    public static final int SIZEOF_CRYPTO_HASH_SHA256_STATE = 128;
    public static final int SIZEOF_CRYPTO_HASH_SHA512_STATE = 256;
    public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_ZEROBYTES = 32;
    public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_BOXZEROBYTES = 16;
    public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_MACBYTES = 16;
    public static final int CRYPTO_BOX_SEALBYTES = 48;
    public static final int CRYPTO_SCALARMULT_CURVE25519_SCALARBYTES = 32;
    public static final int CRYPTO_BOX_PUBLICKEYBYTES = 32;
    public static final int CRYPTO_BOX_SECRETKEYBYTES = 32;
    public static final int CRYPTO_BOX_MACBYTES = 16;
    public static final int CRYPTO_BOX_NONCEBYTES = 24;
    public static final int CRYPTO_BOX_SEEDBYTES = 32;
    public static final int RANDOMBYTES_SEEDBYTES = 32;
    public static final int CRYPTO_BOX_BEFORENMBYTES = 32;
    public static final int CRYPTO_SIGN_BYTES = 64;
    public static final int CRYPTO_SIGN_SEEDBYTES = 32;
    public static final int CRYPTO_SIGN_PUBLICKEYBYTES = 32;
    public static final int CRYPTO_SIGN_SECRETKEYBYTES = 64;
    public static final int SIZEOF_CRYPTO_SIGN_STATE = 256;

    public static void checkValid(int status, String description) throws IllegalStateException {
        if (status != 0) {
            throw new IllegalStateException(description + ", status: " + status);
        }
    }

    public int sodium_init();

    public String sodium_version_string();

    public void sodium_memzero(@In long var1, @In @u_int64_t long var3);

    public void sodium_increment(@In long var1, @In @u_int64_t int var3);

    public void randombytes(@In long var1, @In @u_int64_t int var3);

    public void randombytes_buf(@In long var1, @In @u_int64_t int var3);

    public void randombytes_buf_deterministic(@In long var1, @In @u_int64_t int var3, @In long var4);

    public int crypto_box_curve25519xsalsa20poly1305_keypair(@In long var1, @In long var3);

    public int crypto_sign_ed25519_seed_keypair(@In long var1, @In long var3, @In long var5);

    public int crypto_sign_ed25519(@In long var1, @Out LongLongByReference var3, @In long var4, @In @u_int64_t int var6, @In long var7);

    public int crypto_sign_ed25519_detached(@In long var1, long var3, @In long var5, @In @u_int64_t int var7, @In long var8);

    public int crypto_scalarmult_curve25519(@In long var1, @In long var3, @In long var5);

    public int crypto_generichash(@In @caddr_t long var1, @In @u_int64_t int var3, @In @caddr_t long var4, @In @u_int64_t int var6, @In @caddr_t long var7, @In @u_int64_t int var9);

    public int crypto_generichash_init(@In @caddr_t long var1, @In @caddr_t long var3, @In @u_int64_t int var5, @In @u_int64_t int var6);

    public int crypto_generichash_update(@In @caddr_t long var1, @In @caddr_t long var3, @In @u_int64_t long var5);

    public int crypto_generichash_final(@In @caddr_t long var1, @In @caddr_t long var3, @In @u_int64_t long var5);

    public int crypto_hash_sha256(@In long var1, @In long var3, @In @u_int64_t int var5);

    public int crypto_hash_sha256_init(@In long var1);

    public int crypto_hash_sha256_update(@In long var1, @In long var3, @In @u_int64_t long var5);

    public int crypto_hash_sha256_final(@In long var1, @In long var3);

    public int crypto_hash_sha512(@In long var1, @In long var3, @In @u_int64_t int var5);

    public int crypto_hash_sha512_init(@In long var1);

    public int crypto_hash_sha512_update(@In long var1, @In long var3, @In @u_int64_t long var5);

    public int crypto_hash_sha512_final(@In long var1, @In long var3);

    public int crypto_sign_ed25519_open(@In long var1, @Out LongLongByReference var3, @In long var4, @In @u_int64_t int var6, @In long var7);

    public int crypto_sign_ed25519_open(@In long var1, long var3, @In long var5, @In @u_int64_t int var7, @In long var8);

    public int crypto_sign_ed25519_verify_detached(@In long var1, @In long var3, @In long var5, @In long var7);

    public int crypto_box_seal(@In long var1, @In long var3, @In @u_int64_t int var5, @In long var6);

    public int crypto_box_seal_open(@In long var1, @In long var3, @In @u_int64_t int var5, @In long var6, @In long var8);

    public void crypto_box_keypair(@In long var1, @In long var3);

    public void crypto_box_seed_keypair(@In long var1, @In long var3, @In long var5);

    public int crypto_box_beforenm(@In long var1, @In long var3, @In long var5);

    public int crypto_box_easy(@In long var1, @In long var3, @In long var5, @In long var7, @In long var9, @In long var11);

    public int crypto_box_easy_afternm(@In long var1, @In long var3, @In long var5, @In long var7, @In long var9);

    public int crypto_box_open_easy(@In long var1, @In long var3, @In long var5, @In long var7, @In long var9, @In long var11);

    public int crypto_box_open_easy_afternm(@In long var1, @In long var3, @In long var5, @In long var7, @In long var9);

    public int crypto_sign_keypair(@In long var1, @In long var3);

    public int crypto_sign_seed_keypair(@In long var1, @In long var3, @In long var5);

    public int crypto_sign(@In long var1, @In long var3, @In long var5, @In long var7, @In long var9);

    public int crypto_sign_open(@In long var1, @In long var3, @In long var5, @In long var7, @In long var9);

    public int crypto_sign_init(@In long var1);

    public int crypto_sign_update(@In long var1, @In long var3, @In long var5);

    public int crypto_sign_final_create(@In long var1, @In long var3, @In long var5, @In long var7);

    public int crypto_sign_final_verify(@In long var1, @In long var3, @In long var5);

    public int crypto_sign_ed25519_sk_to_seed(@In long var1, @In long var3);

    public int crypto_sign_ed25519_sk_to_pk(@In long var1, @In long var3);

    public static final class Util
    extends Enum<Util> {
        private static final /* synthetic */ Util[] $VALUES;

        public static Util[] values() {
            return (Util[])$VALUES.clone();
        }

        public static Util valueOf(String name) {
            return Enum.valueOf(Util.class, name);
        }

        @NotNull
        public static BytesStore setSize(@Nullable BytesStore bs, long size) {
            if (bs == null) {
                return BytesStore.nativeStoreWithFixedCapacity((long)size);
            }
            assert (bs.refCount() > 0);
            if (bs instanceof Bytes) {
                Bytes b = (Bytes)bs;
                b.ensureCapacity(size);
                b.readPositionRemaining(0L, size);
                return b;
            }
            if (bs.capacity() == size) {
                return bs;
            }
            throw new IllegalArgumentException("Capacity expected " + size + " was " + bs.capacity());
        }

        static {
            $VALUES = new Util[0];
        }
    }

    public static enum Init {


        static Sodium init() {
            String libraryName = "sodium";
            if (Platform.getNativePlatform().getOS() == Platform.OS.WINDOWS) {
                libraryName = "libsodium";
            }
            Sodium sodium = null;
            try {
                sodium = (Sodium)LibraryLoader.create(Sodium.class).search("lib").search("/usr/local/lib").search("/opt/local/lib").load(libraryName);
            }
            catch (Error e) {
                if (Platform.getNativePlatform().getOS() == Platform.OS.WINDOWS) {
                    System.err.println("Unable to load libsodium, make sure the Visual C++ Downloadable is installed\nhttps://support.microsoft.com/en-gb/help/2977003/the-latest-supported-visual-c-downloads");
                }
                throw e;
            }
            Sodium.checkValid(sodium.sodium_init(), "sodium_init()");
            return sodium;
        }

        static Bytes<?> fromHex(int padding, String s) {
            byte[] byteArr = DatatypeConverter.parseHexBinary((String)s);
            VanillaBytes bytes = Bytes.allocateDirect((long)(padding + byteArr.length));
            if (padding > 0) {
                bytes.zeroOut(0L, (long)padding);
                bytes.writePosition((long)padding);
            }
            bytes.write(byteArr);
            return bytes;
        }
    }
}

