/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.salt.Sodium;

public enum SHA2 {

    static final int HASH_SHA256_BYTES = 32;
    static final int HASH_SHA512_BYTES = 64;

    public static BytesStore sha256(BytesStore message) {
        return SHA2.sha256(null, message);
    }

    public static BytesStore sha256(BytesStore result, BytesStore message) {
        result = Sodium.Util.setSize(result, 32L);
        Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha256(result.addressForWrite(0L), message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining())), "couldn't SHA256");
        return result;
    }

    public static void appendSha256(Bytes<?> hash256, BytesStore<?, ?> message) {
        long wp = hash256.writePosition();
        hash256.ensureCapacity(wp + 32L);
        Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha256(hash256.addressForWrite(wp), message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining())), "couldn't SHA256");
        hash256.writeSkip(32L);
    }

    public static BytesStore sha512(BytesStore message) {
        return SHA2.sha512(null, message);
    }

    public static BytesStore sha512(BytesStore result, BytesStore message) {
        result = Sodium.Util.setSize(result, 64L);
        Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha512(result.addressForWrite(0L), message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining())), "Couldn't SHA512");
        return result;
    }

    public static void appendSha512(Bytes<?> hash512, BytesStore<?, ?> message) {
        long wp = hash512.writePosition();
        hash512.ensureCapacity(wp + 64L);
        Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha512(hash512.addressForWrite(wp), message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining())), "Couldn't SHA512");
        hash512.writeSkip(64L);
    }

    public static class MultiPartSHA512 {
        public final BytesStore state = Bytes.allocateDirect((long)256L);

        public MultiPartSHA512() {
            ((Bytes)this.state).readLimit(256L);
            Sodium.SODIUM.crypto_hash_sha512_init(this.state.addressForRead(0L));
        }

        public void reset() {
            Sodium.SODIUM.crypto_hash_sha512_init(this.state.addressForRead(0L));
        }

        public void add(BytesStore message) {
            Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha512_update(this.state.addressForRead(0L), message.addressForRead(message.readPosition()), message.readRemaining()), "Failed to add to multi-part message");
        }

        public BytesStore hash() {
            return this.hash(null);
        }

        public BytesStore hash(BytesStore result) {
            result = Sodium.Util.setSize(result, 64L);
            Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha512_final(this.state.addressForRead(0L), result.addressForWrite(0L)), "Multi-part SHA512 failed");
            return result;
        }
    }

    public static class MultiPartSHA256 {
        public final BytesStore state = Bytes.allocateDirect((long)128L);

        public MultiPartSHA256() {
            ((Bytes)this.state).readLimit(128L);
            Sodium.SODIUM.crypto_hash_sha256_init(this.state.addressForRead(0L));
        }

        public void reset() {
            Sodium.SODIUM.crypto_hash_sha256_init(this.state.addressForRead(0L));
        }

        public void add(BytesStore message) {
            Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha256_update(this.state.addressForRead(0L), message.addressForRead(message.readPosition()), message.readRemaining()), "Failed to add to multi-part message");
        }

        public BytesStore hash() {
            return this.hash(null);
        }

        public BytesStore hash(BytesStore result) {
            result = Sodium.Util.setSize(result, 32L);
            Sodium.checkValid(Sodium.SODIUM.crypto_hash_sha256_final(this.state.addressForRead(0L), result.addressForWrite(0L)), "Multi-part SHA256 failed");
            return result;
        }
    }
}

