/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.salt.Sodium;

public enum Signature {


    public static BytesStore sign(BytesStore message, SecretKey secretKey) {
        return Signature.sign(null, message, secretKey);
    }

    public static BytesStore sign(BytesStore result, BytesStore message, SecretKey secretKey) {
        return Signature.sign(result, message, secretKey.store);
    }

    public static BytesStore sign(BytesStore result, BytesStore message, BytesStore secretKey) {
        if (secretKey == null) {
            throw new RuntimeException("Sign failed. Secret key not available.");
        }
        long length = message.readRemaining();
        long resultLength = length + 64L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Sodium.SODIUM.crypto_sign(result.addressForWrite(0L), 0L, message.addressForRead(message.readPosition()), length, secretKey.addressForRead(secretKey.readPosition())), "Signing failed");
        return result;
    }

    @NotNull
    public static BytesStore verify(@NotNull BytesStore message, PublicKey publicKey) {
        return Signature.verify(null, message, publicKey);
    }

    public static BytesStore verify(@Nullable BytesStore result, @NotNull BytesStore message, PublicKey publicKey) {
        return Signature.verify(result, message, publicKey.store);
    }

    public static BytesStore verify(@Nullable BytesStore result, @NotNull BytesStore message, BytesStore publicKey) {
        if (publicKey == null) {
            throw new RuntimeException("Decryption failed. Public key not available.");
        }
        long length = message.readRemaining();
        long resultLength = length - 64L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Sodium.SODIUM.crypto_sign_open(result.addressForWrite(0L), 0L, message.addressForRead(message.readPosition()), length, publicKey.addressForRead(publicKey.readPosition())), "Signature verification failed");
        return result;
    }

    public static class MultiPart {
        public final BytesStore state = Bytes.allocateDirect((long)256L);

        public MultiPart() {
            ((Bytes)this.state).readLimit(256L);
            Sodium.SODIUM.crypto_sign_init(this.state.addressForRead(0L));
        }

        void reset() {
            Sodium.SODIUM.crypto_sign_init(this.state.addressForRead(0L));
        }

        public void add(BytesStore message) {
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_update(this.state.addressForRead(0L), message.addressForRead(message.readPosition()), message.readRemaining()), "Failed to add to multi-part message");
        }

        public BytesStore sign(SecretKey sk) {
            return this.sign(sk.store);
        }

        public BytesStore sign(BytesStore sk) {
            BytesStore result = Sodium.Util.setSize(null, 64L);
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_final_create(this.state.addressForRead(0L), result.addressForWrite(0L), 0L, sk.addressForRead(sk.readPosition())), "Multi-part signature failed");
            return result;
        }

        public void verify(BytesStore signature, PublicKey pk) {
            this.verify(signature, pk.store);
        }

        public void verify(BytesStore signature, BytesStore pk) {
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_final_verify(this.state.addressForRead(0L), signature.addressForRead(signature.readPosition()), pk.addressForRead(pk.readPosition())), "Multi-part signature verification failed");
        }
    }

    public static class KeyPair {
        public final PublicKey publicKey;
        public final SecretKey secretKey = new SecretKey();

        private KeyPair() {
            this.publicKey = new PublicKey();
            Sodium.SODIUM.crypto_sign_keypair(this.publicKey.address(), this.secretKey.address());
        }

        private KeyPair(BytesStore seed) {
            this.publicKey = new PublicKey();
            seed = Sodium.Util.setSize(seed, 32L);
            Sodium.SODIUM.crypto_sign_seed_keypair(this.publicKey.address(), this.secretKey.address(), seed.addressForWrite(0L));
        }

        public static KeyPair generate() {
            return new KeyPair();
        }

        public static KeyPair deterministic(long id) {
            VanillaBytes seed = Bytes.allocateDirect((long)32L);
            seed.writeLong(0L, id);
            return KeyPair.deterministic((BytesStore)seed);
        }

        public static KeyPair deterministic(BytesStore seed) {
            return new KeyPair(seed);
        }

        public void wipe() {
            this.secretKey.wipe();
        }
    }

    public static class SecretKey {
        public final BytesStore store = Bytes.allocateDirect((long)64L);

        private SecretKey() {
            ((Bytes)this.store).readLimit(64L);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }

        public void wipe() {
            Sodium.SODIUM.sodium_memzero(this.address(), 64L);
        }

        BytesStore extractSeed() {
            return this.extractSeed(null);
        }

        BytesStore extractSeed(BytesStore seed) {
            seed = Sodium.Util.setSize(seed, 32L);
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_ed25519_sk_to_seed(seed.addressForWrite(0L), this.store.addressForRead(0L)), "Failed to extract seed from signer's secret key");
            return seed;
        }

        BytesStore extractPublicKey() {
            return this.extractPublicKey(null);
        }

        BytesStore extractPublicKey(BytesStore pk) {
            pk = Sodium.Util.setSize(pk, 32L);
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_ed25519_sk_to_pk(pk.addressForWrite(0L), this.store.addressForRead(0L)), "Failed to extract public key from signer's secret key");
            return pk;
        }
    }

    public static class PublicKey {
        public final BytesStore store = Bytes.allocateDirect((long)32L);

        private PublicKey() {
            ((Bytes)this.store).readLimit(32L);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }
    }
}

