/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.openhft.chronicle.releasenotes.model.Issue;
import net.openhft.chronicle.releasenotes.model.IssueComment;

public final class FullIssue
implements Issue {
    private final int number;
    private final String title;
    private final List<String> labels;
    private final List<IssueComment> comments;
    private final URL url;

    public FullIssue(int number, String title, List<String> labels, List<IssueComment> comments, URL url) {
        this.number = number;
        this.title = Objects.requireNonNull(title);
        this.labels = Objects.requireNonNull(labels);
        this.comments = Objects.requireNonNull(comments);
        this.url = Objects.requireNonNull(url);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public List<IssueComment> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    @Override
    public Optional<String> getComment() {
        return this.getComments().stream().filter(issueComment -> issueComment.getBody().startsWith("#comment ")).sorted(Comparator.reverseOrder()).map(issueComment -> issueComment.getBody().substring(issueComment.getBody().indexOf("#comment ") + "#comment ".length())).filter(issueComment -> !issueComment.trim().isEmpty()).findFirst();
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullIssue issue = (FullIssue)o;
        return this.number == issue.number && this.title.equals(issue.title) && this.labels.equals(issue.labels) && this.comments.equals(issue.comments) && this.url.equals(issue.url);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.title, this.labels, this.comments, this.url);
    }

    public String toString() {
        return "FullIssue{number=" + this.number + ", title='" + this.title + '\'' + ", labels=" + this.labels + ", comments=" + this.comments + ", url=" + this.url.toString() + '}';
    }
}

